// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Information about a player session that was created as part of a StartGameSessionPlacement request. This object contains only the player
 * ID and player session ID. To retrieve full details on a player session, call DescribePlayerSessions with the player session ID.
 *
 * Related actions
 *
 *
 * CreatePlayerSession |
 * CreatePlayerSessions |
 * DescribePlayerSessions |
 * StartGameSessionPlacement |
 * DescribeGameSessionPlacement |
 * StopGameSessionPlacement |
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task
 */
class PlacedPlayerSession private constructor(builder: Builder) {
    /**
     * A unique identifier for a player that is associated with this player session.
     */
    val playerId: kotlin.String? = builder.playerId
    /**
     * A unique identifier for a player session.
     */
    val playerSessionId: kotlin.String? = builder.playerSessionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.PlacedPlayerSession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlacedPlayerSession(")
        append("playerId=$playerId,")
        append("playerSessionId=$playerSessionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = playerId?.hashCode() ?: 0
        result = 31 * result + (playerSessionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlacedPlayerSession

        if (playerId != other.playerId) return false
        if (playerSessionId != other.playerSessionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.PlacedPlayerSession = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for a player that is associated with this player session.
         */
        var playerId: kotlin.String? = null
        /**
         * A unique identifier for a player session.
         */
        var playerSessionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.PlacedPlayerSession) : this() {
            this.playerId = x.playerId
            this.playerSessionId = x.playerSessionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.PlacedPlayerSession = PlacedPlayerSession(this)
    }
}
