// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Regional latency information for a player, used when requesting a new game session
 * with StartGameSessionPlacement. This value indicates the amount of
 * time lag that exists when the player is connected to a fleet in the specified Region.
 * The relative difference between a player's latency values for multiple Regions are used
 * to determine which fleets are best suited to place a new game session for the player.
 */
class PlayerLatency private constructor(builder: Builder) {
    /**
     * Amount of time that represents the time lag experienced by the player when
     * connected to the specified Region.
     */
    val latencyInMilliseconds: kotlin.Float = builder.latencyInMilliseconds
    /**
     * A unique identifier for a player associated with the latency data.
     */
    val playerId: kotlin.String? = builder.playerId
    /**
     * Name of the Region that is associated with the latency value.
     */
    val regionIdentifier: kotlin.String? = builder.regionIdentifier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.PlayerLatency = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlayerLatency(")
        append("latencyInMilliseconds=$latencyInMilliseconds,")
        append("playerId=$playerId,")
        append("regionIdentifier=$regionIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = latencyInMilliseconds.hashCode()
        result = 31 * result + (playerId?.hashCode() ?: 0)
        result = 31 * result + (regionIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlayerLatency

        if (latencyInMilliseconds != other.latencyInMilliseconds) return false
        if (playerId != other.playerId) return false
        if (regionIdentifier != other.regionIdentifier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.PlayerLatency = Builder(this).apply(block).build()

    class Builder {
        /**
         * Amount of time that represents the time lag experienced by the player when
         * connected to the specified Region.
         */
        var latencyInMilliseconds: kotlin.Float = 0.0f
        /**
         * A unique identifier for a player associated with the latency data.
         */
        var playerId: kotlin.String? = null
        /**
         * Name of the Region that is associated with the latency value.
         */
        var regionIdentifier: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.PlayerLatency) : this() {
            this.latencyInMilliseconds = x.latencyInMilliseconds
            this.playerId = x.playerId
            this.regionIdentifier = x.regionIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.PlayerLatency = PlayerLatency(this)
    }
}
