// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a player session. Player sessions are created either for a specific game
 * session, or as part of a game session placement or matchmaking request. A player session
 * can represents a reserved player slot in a game session (when status is
 * RESERVED) or actual player activity in a game session (when status is
 * ACTIVE). A player session object, including player data, is
 * automatically passed to a game session when the player connects to the game session and
 * is validated. After the game session ends, player sessions information is retained for
 * 30 days and then removed.
 *
 * Related actions
 *
 *
 * CreatePlayerSession |
 * CreatePlayerSessions |
 * DescribePlayerSessions |
 * StartGameSessionPlacement |
 * DescribeGameSessionPlacement |
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task
 */
class PlayerSession private constructor(builder: Builder) {
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The DNS identifier assigned to the instance that is running the game session. Values have
     * the following format:
     *
     *
     * TLS-enabled fleets: <unique identifier>.<region identifier>.amazongamelift.com.
     *
     * Non-TLS-enabled fleets: ec2-<unique identifier>.compute.amazonaws.com. (See
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing.)
     *
     *
     * When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.
     */
    val dnsName: kotlin.String? = builder.dnsName
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) associated with the GameLift fleet that the player's game session is running on.
     */
    val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet that the player's game session is running on.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * A unique identifier for the game session that the player session is connected to.
     */
    val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.
     */
    val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.
     */
    val playerData: kotlin.String? = builder.playerData
    /**
     * A unique identifier for a player that is associated with this player session.
     */
    val playerId: kotlin.String? = builder.playerId
    /**
     * A unique identifier for a player session.
     */
    val playerSessionId: kotlin.String? = builder.playerSessionId
    /**
     * Port number for the game session. To connect to a Amazon GameLift server process, an app
     * needs both the IP address and port number.
     */
    val port: kotlin.Int? = builder.port
    /**
     * Current status of the player session.
     * Possible player session statuses include the following:
     *
     *
     *
     * RESERVED -- The player session request has been
     * received, but the player has not yet connected to the server process and/or been
     * validated.
     *
     *
     * ACTIVE -- The player has been validated by the
     * server process and is currently connected.
     *
     *
     * COMPLETED -- The player connection has been
     * dropped.
     *
     *
     * TIMEDOUT -- A player session request was
     * received, but the player did not connect and/or was not validated within the
     * timeout limit (60 seconds).
     */
    val status: aws.sdk.kotlin.services.gamelift.model.PlayerSessionStatus? = builder.status
    /**
     * A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val terminationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.terminationTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.PlayerSession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlayerSession(")
        append("creationTime=$creationTime,")
        append("dnsName=$dnsName,")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("gameSessionId=$gameSessionId,")
        append("ipAddress=$ipAddress,")
        append("playerData=$playerData,")
        append("playerId=$playerId,")
        append("playerSessionId=$playerSessionId,")
        append("port=$port,")
        append("status=$status,")
        append("terminationTime=$terminationTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (gameSessionId?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (playerData?.hashCode() ?: 0)
        result = 31 * result + (playerId?.hashCode() ?: 0)
        result = 31 * result + (playerSessionId?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (terminationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlayerSession

        if (creationTime != other.creationTime) return false
        if (dnsName != other.dnsName) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (gameSessionId != other.gameSessionId) return false
        if (ipAddress != other.ipAddress) return false
        if (playerData != other.playerData) return false
        if (playerId != other.playerId) return false
        if (playerSessionId != other.playerSessionId) return false
        if (port != other.port) return false
        if (status != other.status) return false
        if (terminationTime != other.terminationTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.PlayerSession = Builder(this).apply(block).build()

    class Builder {
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS identifier assigned to the instance that is running the game session. Values have
         * the following format:
         *
         *
         * TLS-enabled fleets: <unique identifier>.<region identifier>.amazongamelift.com.
         *
         * Non-TLS-enabled fleets: ec2-<unique identifier>.compute.amazonaws.com. (See
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing.)
         *
         *
         * When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.
         */
        var dnsName: kotlin.String? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) associated with the GameLift fleet that the player's game session is running on.
         */
        var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet that the player's game session is running on.
         */
        var fleetId: kotlin.String? = null
        /**
         * A unique identifier for the game session that the player session is connected to.
         */
        var gameSessionId: kotlin.String? = null
        /**
         * The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.
         */
        var ipAddress: kotlin.String? = null
        /**
         * Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.
         */
        var playerData: kotlin.String? = null
        /**
         * A unique identifier for a player that is associated with this player session.
         */
        var playerId: kotlin.String? = null
        /**
         * A unique identifier for a player session.
         */
        var playerSessionId: kotlin.String? = null
        /**
         * Port number for the game session. To connect to a Amazon GameLift server process, an app
         * needs both the IP address and port number.
         */
        var port: kotlin.Int? = null
        /**
         * Current status of the player session.
         * Possible player session statuses include the following:
         *
         *
         *
         * RESERVED -- The player session request has been
         * received, but the player has not yet connected to the server process and/or been
         * validated.
         *
         *
         * ACTIVE -- The player has been validated by the
         * server process and is currently connected.
         *
         *
         * COMPLETED -- The player connection has been
         * dropped.
         *
         *
         * TIMEDOUT -- A player session request was
         * received, but the player did not connect and/or was not validated within the
         * timeout limit (60 seconds).
         */
        var status: aws.sdk.kotlin.services.gamelift.model.PlayerSessionStatus? = null
        /**
         * A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var terminationTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.PlayerSession) : this() {
            this.creationTime = x.creationTime
            this.dnsName = x.dnsName
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.gameSessionId = x.gameSessionId
            this.ipAddress = x.ipAddress
            this.playerData = x.playerData
            this.playerId = x.playerId
            this.playerSessionId = x.playerSessionId
            this.port = x.port
            this.status = x.status
            this.terminationTime = x.terminationTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.PlayerSession = PlayerSession(this)
    }
}
