// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * A collection of server process configurations that describe the set of processes to
 * run on each instance in a fleet. Server processes run either an executable in a custom
 * game build or a Realtime Servers script. GameLift launches the configured processes, manages their
 * life cycle, and replaces them as needed. Each instance checks regularly for an updated
 * runtime configuration.
 * A GameLift instance is limited to 50 processes running concurrently. To calculate the
 * total number of processes in a runtime configuration, add the values of the
 * ConcurrentExecutions parameter for each ServerProcess. Learn more about <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html"> Running Multiple
 * Processes on a Fleet.
 *
 * Related actions
 *
 *
 * DescribeRuntimeConfiguration | UpdateRuntimeConfiguration
 */
class RuntimeConfiguration private constructor(builder: Builder) {
    /**
     * The maximum amount of time (in seconds) allowed to launch a new game session and have
     * it report ready to host players. During this time, the game session is in status
     * ACTIVATING. If the game session does not become active before the
     * timeout, it is ended and the game session status is changed to
     * TERMINATED.
     */
    val gameSessionActivationTimeoutSeconds: kotlin.Int? = builder.gameSessionActivationTimeoutSeconds
    /**
     * The number of game sessions in status ACTIVATING to allow on an instance.
     * This setting limits the instance resources that can be used for new game activations at
     * any one time.
     */
    val maxConcurrentGameSessionActivations: kotlin.Int? = builder.maxConcurrentGameSessionActivations
    /**
     * A collection of server process configurations that identify what server processes to
     * run on each instance in a fleet.
     */
    val serverProcesses: List<ServerProcess>? = builder.serverProcesses

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuntimeConfiguration(")
        append("gameSessionActivationTimeoutSeconds=$gameSessionActivationTimeoutSeconds,")
        append("maxConcurrentGameSessionActivations=$maxConcurrentGameSessionActivations,")
        append("serverProcesses=$serverProcesses)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameSessionActivationTimeoutSeconds ?: 0
        result = 31 * result + (maxConcurrentGameSessionActivations ?: 0)
        result = 31 * result + (serverProcesses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuntimeConfiguration

        if (gameSessionActivationTimeoutSeconds != other.gameSessionActivationTimeoutSeconds) return false
        if (maxConcurrentGameSessionActivations != other.maxConcurrentGameSessionActivations) return false
        if (serverProcesses != other.serverProcesses) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum amount of time (in seconds) allowed to launch a new game session and have
         * it report ready to host players. During this time, the game session is in status
         * ACTIVATING. If the game session does not become active before the
         * timeout, it is ended and the game session status is changed to
         * TERMINATED.
         */
        var gameSessionActivationTimeoutSeconds: kotlin.Int? = null
        /**
         * The number of game sessions in status ACTIVATING to allow on an instance.
         * This setting limits the instance resources that can be used for new game activations at
         * any one time.
         */
        var maxConcurrentGameSessionActivations: kotlin.Int? = null
        /**
         * A collection of server process configurations that identify what server processes to
         * run on each instance in a fleet.
         */
        var serverProcesses: List<ServerProcess>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration) : this() {
            this.gameSessionActivationTimeoutSeconds = x.gameSessionActivationTimeoutSeconds
            this.maxConcurrentGameSessionActivations = x.maxConcurrentGameSessionActivations
            this.serverProcesses = x.serverProcesses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration = RuntimeConfiguration(this)
    }
}
