// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * The location in Amazon S3 where build or script files are stored for access by Amazon GameLift. This
 * location is specified in CreateBuild, CreateScript,
 * and UpdateScript requests.
 */
class S3Location private constructor(builder: Builder) {
    /**
     * An Amazon S3 bucket identifier. This is the name of the S3 bucket.
     *
     * GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * The name of the zip file that contains the build files or script files.
     */
    val key: kotlin.String? = builder.key
    /**
     * The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses
     * this information when retrieving files from an S3 bucket that you own. Use this
     * parameter to specify a specific version of the file. If not set, the latest version of
     * the file is retrieved.
     */
    val objectVersion: kotlin.String? = builder.objectVersion
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) for an IAM role that
     * allows Amazon GameLift to access the S3 bucket.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.S3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("bucket=$bucket,")
        append("key=$key,")
        append("objectVersion=$objectVersion,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (objectVersion?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Location

        if (bucket != other.bucket) return false
        if (key != other.key) return false
        if (objectVersion != other.objectVersion) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.S3Location = Builder(this).apply(block).build()

    class Builder {
        /**
         * An Amazon S3 bucket identifier. This is the name of the S3 bucket.
         *
         * GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).
         */
        var bucket: kotlin.String? = null
        /**
         * The name of the zip file that contains the build files or script files.
         */
        var key: kotlin.String? = null
        /**
         * The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses
         * this information when retrieving files from an S3 bucket that you own. Use this
         * parameter to specify a specific version of the file. If not set, the latest version of
         * the file is retrieved.
         */
        var objectVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) for an IAM role that
         * allows Amazon GameLift to access the S3 bucket.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.S3Location) : this() {
            this.bucket = x.bucket
            this.key = x.key
            this.objectVersion = x.objectVersion
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.S3Location = S3Location(this)
    }
}
