// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Rule that controls how a fleet is scaled. Scaling policies are uniquely identified
 * by the combination of name and fleet ID.
 *
 * Related actions
 *
 *
 * DescribeFleetCapacity |
 * UpdateFleetCapacity |
 * DescribeEC2InstanceLimits |
 * PutScalingPolicy |
 * DescribeScalingPolicies |
 * DeleteScalingPolicy |
 * StopFleetActions |
 * StartFleetActions |
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task
 */
class ScalingPolicy private constructor(builder: Builder) {
    /**
     * Comparison operator to use when measuring a metric against the threshold
     * value.
     */
    val comparisonOperator: aws.sdk.kotlin.services.gamelift.model.ComparisonOperatorType? = builder.comparisonOperator
    /**
     * Length of time (in minutes) the metric must be at or beyond the threshold before a
     * scaling event is triggered.
     */
    val evaluationPeriods: kotlin.Int? = builder.evaluationPeriods
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
     */
    val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet that is associated with this scaling policy.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     *
     */
    val location: kotlin.String? = builder.location
    /**
     * Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For
     * detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift
     * with Amazon CloudWatch.
     *
     *
     *
     * ActivatingGameSessions -- Game sessions in
     * the process of being created.
     *
     *
     * ActiveGameSessions -- Game sessions that
     * are currently running.
     *
     *
     * ActiveInstances -- Fleet instances that
     * are currently running at least one game session.
     *
     *
     * AvailableGameSessions -- Additional game
     * sessions that fleet could host simultaneously, given current capacity.
     *
     *
     * AvailablePlayerSessions -- Empty player
     * slots in currently active game sessions. This includes game sessions that are
     * not currently accepting players. Reserved player slots are not
     * included.
     *
     *
     * CurrentPlayerSessions -- Player slots in
     * active game sessions that are being used by a player or are reserved for a
     * player.
     *
     *
     * IdleInstances -- Active instances that are
     * currently hosting zero game sessions.
     *
     *
     * PercentAvailableGameSessions -- Unused
     * percentage of the total number of game sessions that a fleet could host
     * simultaneously, given current capacity. Use this metric for a target-based
     * scaling policy.
     *
     *
     * PercentIdleInstances -- Percentage of the
     * total number of active instances that are hosting zero game sessions.
     *
     *
     * QueueDepth -- Pending game session
     * placement requests, in any queue, where the current fleet is the top-priority
     * destination.
     *
     *
     * WaitTime -- Current wait time for pending
     * game session placement requests, in any queue, where the current fleet is the
     * top-priority destination.
     */
    val metricName: aws.sdk.kotlin.services.gamelift.model.MetricName? = builder.metricName
    /**
     * A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
     */
    val name: kotlin.String? = builder.name
    /**
     * The type of scaling policy to create. For a target-based policy, set the parameter
     * MetricName to 'PercentAvailableGameSessions' and specify a
     * TargetConfiguration. For a rule-based policy set the following
     * parameters: MetricName, ComparisonOperator,
     * Threshold, EvaluationPeriods,
     * ScalingAdjustmentType, and
     * ScalingAdjustment.
     */
    val policyType: aws.sdk.kotlin.services.gamelift.model.PolicyType? = builder.policyType
    /**
     * Amount of adjustment to make, based on the scaling adjustment type.
     */
    val scalingAdjustment: kotlin.Int = builder.scalingAdjustment
    /**
     * The type of adjustment to make to a fleet's instance count (see FleetCapacity):
     *
     *
     *
     * ChangeInCapacity -- add (or subtract) the
     * scaling adjustment value from the current instance count. Positive values scale
     * up while negative values scale down.
     *
     *
     * ExactCapacity -- set the instance count to the
     * scaling adjustment value.
     *
     *
     * PercentChangeInCapacity -- increase or reduce
     * the current instance count by the scaling adjustment, read as a percentage.
     * Positive values scale up while negative values scale down.
     */
    val scalingAdjustmentType: aws.sdk.kotlin.services.gamelift.model.ScalingAdjustmentType? = builder.scalingAdjustmentType
    /**
     * Current status of the scaling policy. The scaling policy can be in force only when
     * in an ACTIVE status. Scaling policies can be suspended for individual
     * fleets (see StopFleetActions; if suspended for a fleet, the policy
     * status does not change. View a fleet's stopped actions by calling DescribeFleetCapacity.
     *
     *
     *
     * ACTIVE -- The scaling policy can be used for
     * auto-scaling a fleet.
     *
     *
     * UPDATE_REQUESTED -- A request to update the
     * scaling policy has been received.
     *
     *
     * UPDATING -- A change is being made to the
     * scaling policy.
     *
     *
     * DELETE_REQUESTED -- A request to delete the
     * scaling policy has been received.
     *
     *
     * DELETING -- The scaling policy is being
     * deleted.
     *
     *
     * DELETED -- The scaling policy has been
     * deleted.
     *
     *
     * ERROR -- An error occurred in creating the
     * policy. It should be removed and recreated.
     */
    val status: aws.sdk.kotlin.services.gamelift.model.ScalingStatusType? = builder.status
    /**
     * An object that contains settings for a target-based scaling policy.
     */
    val targetConfiguration: aws.sdk.kotlin.services.gamelift.model.TargetConfiguration? = builder.targetConfiguration
    /**
     * Metric value used to trigger a scaling event.
     */
    val threshold: kotlin.Double = builder.threshold
    /**
     * The current status of the fleet's scaling policies in a requested fleet location. The
     * status PENDING_UPDATE indicates that an update was requested for the fleet
     * but has not yet been completed for the location.
     */
    val updateStatus: aws.sdk.kotlin.services.gamelift.model.LocationUpdateStatus? = builder.updateStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ScalingPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingPolicy(")
        append("comparisonOperator=$comparisonOperator,")
        append("evaluationPeriods=$evaluationPeriods,")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("location=$location,")
        append("metricName=$metricName,")
        append("name=$name,")
        append("policyType=$policyType,")
        append("scalingAdjustment=$scalingAdjustment,")
        append("scalingAdjustmentType=$scalingAdjustmentType,")
        append("status=$status,")
        append("targetConfiguration=$targetConfiguration,")
        append("threshold=$threshold,")
        append("updateStatus=$updateStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparisonOperator?.hashCode() ?: 0
        result = 31 * result + (evaluationPeriods ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (scalingAdjustment)
        result = 31 * result + (scalingAdjustmentType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetConfiguration?.hashCode() ?: 0)
        result = 31 * result + (threshold.hashCode())
        result = 31 * result + (updateStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingPolicy

        if (comparisonOperator != other.comparisonOperator) return false
        if (evaluationPeriods != other.evaluationPeriods) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (location != other.location) return false
        if (metricName != other.metricName) return false
        if (name != other.name) return false
        if (policyType != other.policyType) return false
        if (scalingAdjustment != other.scalingAdjustment) return false
        if (scalingAdjustmentType != other.scalingAdjustmentType) return false
        if (status != other.status) return false
        if (targetConfiguration != other.targetConfiguration) return false
        if (threshold != other.threshold) return false
        if (updateStatus != other.updateStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ScalingPolicy = Builder(this).apply(block).build()

    class Builder {
        /**
         * Comparison operator to use when measuring a metric against the threshold
         * value.
         */
        var comparisonOperator: aws.sdk.kotlin.services.gamelift.model.ComparisonOperatorType? = null
        /**
         * Length of time (in minutes) the metric must be at or beyond the threshold before a
         * scaling event is triggered.
         */
        var evaluationPeriods: kotlin.Int? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
         */
        var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet that is associated with this scaling policy.
         */
        var fleetId: kotlin.String? = null
        /**
         *
         */
        var location: kotlin.String? = null
        /**
         * Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For
         * detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift
         * with Amazon CloudWatch.
         *
         *
         *
         * ActivatingGameSessions -- Game sessions in
         * the process of being created.
         *
         *
         * ActiveGameSessions -- Game sessions that
         * are currently running.
         *
         *
         * ActiveInstances -- Fleet instances that
         * are currently running at least one game session.
         *
         *
         * AvailableGameSessions -- Additional game
         * sessions that fleet could host simultaneously, given current capacity.
         *
         *
         * AvailablePlayerSessions -- Empty player
         * slots in currently active game sessions. This includes game sessions that are
         * not currently accepting players. Reserved player slots are not
         * included.
         *
         *
         * CurrentPlayerSessions -- Player slots in
         * active game sessions that are being used by a player or are reserved for a
         * player.
         *
         *
         * IdleInstances -- Active instances that are
         * currently hosting zero game sessions.
         *
         *
         * PercentAvailableGameSessions -- Unused
         * percentage of the total number of game sessions that a fleet could host
         * simultaneously, given current capacity. Use this metric for a target-based
         * scaling policy.
         *
         *
         * PercentIdleInstances -- Percentage of the
         * total number of active instances that are hosting zero game sessions.
         *
         *
         * QueueDepth -- Pending game session
         * placement requests, in any queue, where the current fleet is the top-priority
         * destination.
         *
         *
         * WaitTime -- Current wait time for pending
         * game session placement requests, in any queue, where the current fleet is the
         * top-priority destination.
         */
        var metricName: aws.sdk.kotlin.services.gamelift.model.MetricName? = null
        /**
         * A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
         */
        var name: kotlin.String? = null
        /**
         * The type of scaling policy to create. For a target-based policy, set the parameter
         * MetricName to 'PercentAvailableGameSessions' and specify a
         * TargetConfiguration. For a rule-based policy set the following
         * parameters: MetricName, ComparisonOperator,
         * Threshold, EvaluationPeriods,
         * ScalingAdjustmentType, and
         * ScalingAdjustment.
         */
        var policyType: aws.sdk.kotlin.services.gamelift.model.PolicyType? = null
        /**
         * Amount of adjustment to make, based on the scaling adjustment type.
         */
        var scalingAdjustment: kotlin.Int = 0
        /**
         * The type of adjustment to make to a fleet's instance count (see FleetCapacity):
         *
         *
         *
         * ChangeInCapacity -- add (or subtract) the
         * scaling adjustment value from the current instance count. Positive values scale
         * up while negative values scale down.
         *
         *
         * ExactCapacity -- set the instance count to the
         * scaling adjustment value.
         *
         *
         * PercentChangeInCapacity -- increase or reduce
         * the current instance count by the scaling adjustment, read as a percentage.
         * Positive values scale up while negative values scale down.
         */
        var scalingAdjustmentType: aws.sdk.kotlin.services.gamelift.model.ScalingAdjustmentType? = null
        /**
         * Current status of the scaling policy. The scaling policy can be in force only when
         * in an ACTIVE status. Scaling policies can be suspended for individual
         * fleets (see StopFleetActions; if suspended for a fleet, the policy
         * status does not change. View a fleet's stopped actions by calling DescribeFleetCapacity.
         *
         *
         *
         * ACTIVE -- The scaling policy can be used for
         * auto-scaling a fleet.
         *
         *
         * UPDATE_REQUESTED -- A request to update the
         * scaling policy has been received.
         *
         *
         * UPDATING -- A change is being made to the
         * scaling policy.
         *
         *
         * DELETE_REQUESTED -- A request to delete the
         * scaling policy has been received.
         *
         *
         * DELETING -- The scaling policy is being
         * deleted.
         *
         *
         * DELETED -- The scaling policy has been
         * deleted.
         *
         *
         * ERROR -- An error occurred in creating the
         * policy. It should be removed and recreated.
         */
        var status: aws.sdk.kotlin.services.gamelift.model.ScalingStatusType? = null
        /**
         * An object that contains settings for a target-based scaling policy.
         */
        var targetConfiguration: aws.sdk.kotlin.services.gamelift.model.TargetConfiguration? = null
        /**
         * Metric value used to trigger a scaling event.
         */
        var threshold: kotlin.Double = 0.0
        /**
         * The current status of the fleet's scaling policies in a requested fleet location. The
         * status PENDING_UPDATE indicates that an update was requested for the fleet
         * but has not yet been completed for the location.
         */
        var updateStatus: aws.sdk.kotlin.services.gamelift.model.LocationUpdateStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ScalingPolicy) : this() {
            this.comparisonOperator = x.comparisonOperator
            this.evaluationPeriods = x.evaluationPeriods
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.location = x.location
            this.metricName = x.metricName
            this.name = x.name
            this.policyType = x.policyType
            this.scalingAdjustment = x.scalingAdjustment
            this.scalingAdjustmentType = x.scalingAdjustmentType
            this.status = x.status
            this.targetConfiguration = x.targetConfiguration
            this.threshold = x.threshold
            this.updateStatus = x.updateStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ScalingPolicy = ScalingPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.TargetConfiguration] inside the given [block]
         */
        fun targetConfiguration(block: aws.sdk.kotlin.services.gamelift.model.TargetConfiguration.Builder.() -> kotlin.Unit) {
            this.targetConfiguration = aws.sdk.kotlin.services.gamelift.model.TargetConfiguration.invoke(block)
        }
    }
}
