// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Properties describing a Realtime script.
 *
 * Related actions
 *
 *
 * CreateScript |
 * ListScripts |
 * DescribeScript |
 * UpdateScript |
 * DeleteScript |
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task
 */
class Script private constructor(builder: Builder) {
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A descriptive label that is associated with a script. Script names do not need to be unique.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions.  In a GameLift script ARN, the resource ID matches the
     * ScriptId value.
     */
    val scriptArn: kotlin.String? = builder.scriptArn
    /**
     * A unique identifier for the Realtime script
     */
    val scriptId: kotlin.String? = builder.scriptId
    /**
     * The file size of the uploaded Realtime script, expressed in bytes. When files are
     * uploaded from an S3 location, this value remains at "0".
     */
    val sizeOnDisk: kotlin.Long? = builder.sizeOnDisk
    /**
     * The location in Amazon S3 where build or script files are stored for access by Amazon GameLift. This
     * location is specified in CreateBuild, CreateScript,
     * and UpdateScript requests.
     */
    val storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = builder.storageLocation
    /**
     * Version information that is associated with a build or script. Version strings do not need to be unique.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Script = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Script(")
        append("creationTime=$creationTime,")
        append("name=$name,")
        append("scriptArn=$scriptArn,")
        append("scriptId=$scriptId,")
        append("sizeOnDisk=$sizeOnDisk,")
        append("storageLocation=$storageLocation,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scriptArn?.hashCode() ?: 0)
        result = 31 * result + (scriptId?.hashCode() ?: 0)
        result = 31 * result + (sizeOnDisk?.hashCode() ?: 0)
        result = 31 * result + (storageLocation?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Script

        if (creationTime != other.creationTime) return false
        if (name != other.name) return false
        if (scriptArn != other.scriptArn) return false
        if (scriptId != other.scriptId) return false
        if (sizeOnDisk != other.sizeOnDisk) return false
        if (storageLocation != other.storageLocation) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Script = Builder(this).apply(block).build()

    class Builder {
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A descriptive label that is associated with a script. Script names do not need to be unique.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions.  In a GameLift script ARN, the resource ID matches the
         * ScriptId value.
         */
        var scriptArn: kotlin.String? = null
        /**
         * A unique identifier for the Realtime script
         */
        var scriptId: kotlin.String? = null
        /**
         * The file size of the uploaded Realtime script, expressed in bytes. When files are
         * uploaded from an S3 location, this value remains at "0".
         */
        var sizeOnDisk: kotlin.Long? = null
        /**
         * The location in Amazon S3 where build or script files are stored for access by Amazon GameLift. This
         * location is specified in CreateBuild, CreateScript,
         * and UpdateScript requests.
         */
        var storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = null
        /**
         * Version information that is associated with a build or script. Version strings do not need to be unique.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Script) : this() {
            this.creationTime = x.creationTime
            this.name = x.name
            this.scriptArn = x.scriptArn
            this.scriptId = x.scriptId
            this.sizeOnDisk = x.sizeOnDisk
            this.storageLocation = x.storageLocation
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Script = Script(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.S3Location] inside the given [block]
         */
        fun storageLocation(block: aws.sdk.kotlin.services.gamelift.model.S3Location.Builder.() -> kotlin.Unit) {
            this.storageLocation = aws.sdk.kotlin.services.gamelift.model.S3Location.invoke(block)
        }
    }
}
