// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class SearchGameSessionsRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the alias associated with the fleet to search for active game sessions. You can use either
     * the alias ID or ARN value. Each request must reference either a fleet ID or alias ID,
     * but not both.
     */
    val aliasId: kotlin.String? = builder.aliasId
    /**
     * String containing the search criteria for the session search. If no filter
     * expression is included, the request returns results for all game sessions in the fleet
     * that are in ACTIVE status.
     * A filter expression can contain one or multiple conditions. Each condition consists
     * of the following:
     *
     *
     *
     * Operand -- Name of a game session
     * attribute. Valid values are gameSessionName,
     * gameSessionId, gameSessionProperties,
     * maximumSessions, creationTimeMillis,
     * playerSessionCount,
     * hasAvailablePlayerSessions.
     *
     *
     * Comparator -- Valid comparators are:
     * =, <>, <, >,
     * <=, >=.
     *
     *
     * Value -- Value to be searched for. Values
     * may be numbers, boolean values (true/false) or strings depending on the operand.
     * String values are case sensitive and must be enclosed in single quotes. Special
     * characters must be escaped. Boolean and string values can only be used with the
     * comparators = and <>. For example, the following
     * filter expression searches on gameSessionName:
     * "FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game
     * 1'".
     *
     *
     * To chain multiple conditions in a single expression, use the logical keywords
     * AND, OR, and NOT and parentheses as needed.
     * For example: x AND y AND NOT z, NOT (x OR y).
     * Session search evaluates conditions from left to right using the following
     * precedence rules:
     * <ol>
     *
     *
     * =, <>, <, >,
     * <=, >=
     *
     *
     * Parentheses
     *
     * NOT
     *
     * AND
     *
     * OR
     *
     * </ol>
     * For example, this filter expression retrieves game sessions hosting at least ten
     * players that have an open player slot: "maximumSessions>=10 AND
     * hasAvailablePlayerSessions=true".
     */
    val filterExpression: kotlin.String? = builder.filterExpression
    /**
     * A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID or ARN
     * value. Each request must reference either a fleet ID or alias ID, but not both.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. The maximum number of results returned is 20, even if this value is not set
     * or is set higher than 20.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * A fleet location to search for game sessions. You can specify a fleet's home Region or
     * a remote location. Use the AWS Region code format, such as us-west-2.
     */
    val location: kotlin.String? = builder.location
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * Instructions on how to sort the search results. If no sort expression is included,
     * the request returns results in random order. A sort expression consists of the following
     * elements:
     *
     *
     *
     * Operand -- Name of a game session attribute.
     * Valid values are gameSessionName, gameSessionId,
     * gameSessionProperties, maximumSessions,
     * creationTimeMillis, playerSessionCount,
     * hasAvailablePlayerSessions.
     *
     *
     * Order -- Valid sort orders are ASC
     * (ascending) and DESC (descending).
     *
     *
     * For example, this sort expression returns the oldest active sessions first:
     * "SortExpression": "creationTimeMillis ASC". Results with a null value
     * for the sort operand are returned at the end of the list.
     */
    val sortExpression: kotlin.String? = builder.sortExpression

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchGameSessionsRequest(")
        append("aliasId=$aliasId,")
        append("filterExpression=$filterExpression,")
        append("fleetId=$fleetId,")
        append("limit=$limit,")
        append("location=$location,")
        append("nextToken=$nextToken,")
        append("sortExpression=$sortExpression)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasId?.hashCode() ?: 0
        result = 31 * result + (filterExpression?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortExpression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchGameSessionsRequest

        if (aliasId != other.aliasId) return false
        if (filterExpression != other.filterExpression) return false
        if (fleetId != other.fleetId) return false
        if (limit != other.limit) return false
        if (location != other.location) return false
        if (nextToken != other.nextToken) return false
        if (sortExpression != other.sortExpression) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the alias associated with the fleet to search for active game sessions. You can use either
         * the alias ID or ARN value. Each request must reference either a fleet ID or alias ID,
         * but not both.
         */
        var aliasId: kotlin.String? = null
        /**
         * String containing the search criteria for the session search. If no filter
         * expression is included, the request returns results for all game sessions in the fleet
         * that are in ACTIVE status.
         * A filter expression can contain one or multiple conditions. Each condition consists
         * of the following:
         *
         *
         *
         * Operand -- Name of a game session
         * attribute. Valid values are gameSessionName,
         * gameSessionId, gameSessionProperties,
         * maximumSessions, creationTimeMillis,
         * playerSessionCount,
         * hasAvailablePlayerSessions.
         *
         *
         * Comparator -- Valid comparators are:
         * =, <>, <, >,
         * <=, >=.
         *
         *
         * Value -- Value to be searched for. Values
         * may be numbers, boolean values (true/false) or strings depending on the operand.
         * String values are case sensitive and must be enclosed in single quotes. Special
         * characters must be escaped. Boolean and string values can only be used with the
         * comparators = and <>. For example, the following
         * filter expression searches on gameSessionName:
         * "FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game
         * 1'".
         *
         *
         * To chain multiple conditions in a single expression, use the logical keywords
         * AND, OR, and NOT and parentheses as needed.
         * For example: x AND y AND NOT z, NOT (x OR y).
         * Session search evaluates conditions from left to right using the following
         * precedence rules:
         * <ol>
         *
         *
         * =, <>, <, >,
         * <=, >=
         *
         *
         * Parentheses
         *
         * NOT
         *
         * AND
         *
         * OR
         *
         * </ol>
         * For example, this filter expression retrieves game sessions hosting at least ten
         * players that have an open player slot: "maximumSessions>=10 AND
         * hasAvailablePlayerSessions=true".
         */
        var filterExpression: kotlin.String? = null
        /**
         * A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID or ARN
         * value. Each request must reference either a fleet ID or alias ID, but not both.
         */
        var fleetId: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. The maximum number of results returned is 20, even if this value is not set
         * or is set higher than 20.
         */
        var limit: kotlin.Int? = null
        /**
         * A fleet location to search for game sessions. You can specify a fleet's home Region or
         * a remote location. Use the AWS Region code format, such as us-west-2.
         */
        var location: kotlin.String? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        var nextToken: kotlin.String? = null
        /**
         * Instructions on how to sort the search results. If no sort expression is included,
         * the request returns results in random order. A sort expression consists of the following
         * elements:
         *
         *
         *
         * Operand -- Name of a game session attribute.
         * Valid values are gameSessionName, gameSessionId,
         * gameSessionProperties, maximumSessions,
         * creationTimeMillis, playerSessionCount,
         * hasAvailablePlayerSessions.
         *
         *
         * Order -- Valid sort orders are ASC
         * (ascending) and DESC (descending).
         *
         *
         * For example, this sort expression returns the oldest active sessions first:
         * "SortExpression": "creationTimeMillis ASC". Results with a null value
         * for the sort operand are returned at the end of the list.
         */
        var sortExpression: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsRequest) : this() {
            this.aliasId = x.aliasId
            this.filterExpression = x.filterExpression
            this.fleetId = x.fleetId
            this.limit = x.limit
            this.location = x.location
            this.nextToken = x.nextToken
            this.sortExpression = x.sortExpression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsRequest = SearchGameSessionsRequest(this)
    }
}
