// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class StartGameSessionPlacementRequest private constructor(builder: Builder) {
    /**
     * Set of information on each player to create a player session for.
     */
    val desiredPlayerSessions: List<DesiredPlayerSession>? = builder.desiredPlayerSessions
    /**
     * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the
     * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session).
     */
    val gameProperties: List<GameProperty>? = builder.gameProperties
    /**
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the
     * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session).
     */
    val gameSessionData: kotlin.String? = builder.gameSessionData
    /**
     * A descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    val gameSessionName: kotlin.String? = builder.gameSessionName
    /**
     * Name of the queue to use to place the new game session. You can use either the queue name
     * or ARN value.
     */
    val gameSessionQueueName: kotlin.String? = builder.gameSessionQueueName
    /**
     * The maximum number of players that can be connected simultaneously to the game session.
     */
    val maximumPlayerSessionCount: kotlin.Int? = builder.maximumPlayerSessionCount
    /**
     * A unique identifier to assign to the new game session placement. This value is
     * developer-defined. The value must be unique across all Regions and cannot be reused
     * unless you are resubmitting a canceled or timed-out placement request.
     */
    val placementId: kotlin.String? = builder.placementId
    /**
     * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to AWS Regions. This information is used to try to place the new game session where
     * it can offer the best possible gameplay experience for the players.
     */
    val playerLatencies: List<PlayerLatency>? = builder.playerLatencies

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartGameSessionPlacementRequest(")
        append("desiredPlayerSessions=$desiredPlayerSessions,")
        append("gameProperties=$gameProperties,")
        append("gameSessionData=$gameSessionData,")
        append("gameSessionName=$gameSessionName,")
        append("gameSessionQueueName=$gameSessionQueueName,")
        append("maximumPlayerSessionCount=$maximumPlayerSessionCount,")
        append("placementId=$placementId,")
        append("playerLatencies=$playerLatencies)")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredPlayerSessions?.hashCode() ?: 0
        result = 31 * result + (gameProperties?.hashCode() ?: 0)
        result = 31 * result + (gameSessionData?.hashCode() ?: 0)
        result = 31 * result + (gameSessionName?.hashCode() ?: 0)
        result = 31 * result + (gameSessionQueueName?.hashCode() ?: 0)
        result = 31 * result + (maximumPlayerSessionCount ?: 0)
        result = 31 * result + (placementId?.hashCode() ?: 0)
        result = 31 * result + (playerLatencies?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartGameSessionPlacementRequest

        if (desiredPlayerSessions != other.desiredPlayerSessions) return false
        if (gameProperties != other.gameProperties) return false
        if (gameSessionData != other.gameSessionData) return false
        if (gameSessionName != other.gameSessionName) return false
        if (gameSessionQueueName != other.gameSessionQueueName) return false
        if (maximumPlayerSessionCount != other.maximumPlayerSessionCount) return false
        if (placementId != other.placementId) return false
        if (playerLatencies != other.playerLatencies) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Set of information on each player to create a player session for.
         */
        var desiredPlayerSessions: List<DesiredPlayerSession>? = null
        /**
         * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the
         * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session).
         */
        var gameProperties: List<GameProperty>? = null
        /**
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the
         * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session).
         */
        var gameSessionData: kotlin.String? = null
        /**
         * A descriptive label that is associated with a game session. Session names do not need to be unique.
         */
        var gameSessionName: kotlin.String? = null
        /**
         * Name of the queue to use to place the new game session. You can use either the queue name
         * or ARN value.
         */
        var gameSessionQueueName: kotlin.String? = null
        /**
         * The maximum number of players that can be connected simultaneously to the game session.
         */
        var maximumPlayerSessionCount: kotlin.Int? = null
        /**
         * A unique identifier to assign to the new game session placement. This value is
         * developer-defined. The value must be unique across all Regions and cannot be reused
         * unless you are resubmitting a canceled or timed-out placement request.
         */
        var placementId: kotlin.String? = null
        /**
         * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to AWS Regions. This information is used to try to place the new game session where
         * it can offer the best possible gameplay experience for the players.
         */
        var playerLatencies: List<PlayerLatency>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest) : this() {
            this.desiredPlayerSessions = x.desiredPlayerSessions
            this.gameProperties = x.gameProperties
            this.gameSessionData = x.gameSessionData
            this.gameSessionName = x.gameSessionName
            this.gameSessionQueueName = x.gameSessionQueueName
            this.maximumPlayerSessionCount = x.maximumPlayerSessionCount
            this.placementId = x.placementId
            this.playerLatencies = x.playerLatencies
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest = StartGameSessionPlacementRequest(this)
    }
}
