// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class StartMatchBackfillRequest private constructor(builder: Builder) {
    /**
     * Name of the matchmaker to use for this request. You can use either the configuration
     * name or ARN value. The ARN of the matchmaker that was used with the original game
     * session is listed in the GameSession object,
     * MatchmakerData property.
     */
    val configurationName: kotlin.String? = builder.configurationName
    /**
     * A unique identifier for the game session. Use the game session ID. When using FlexMatch as a standalone matchmaking
     * solution, this parameter is not needed.
     */
    val gameSessionArn: kotlin.String? = builder.gameSessionArn
    /**
     * Match information on all players that are currently assigned to the game session.
     * This information is used by the matchmaker to find new players and add them to the
     * existing game.
     *
     *
     * PlayerID, PlayerAttributes, Team -- This information is maintained in the
     * GameSession object, MatchmakerData property,
     * for all players who are currently assigned to the game session. The matchmaker
     * data is in JSON syntax, formatted as a string. For more details, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">
     * Match Data.
     *
     * LatencyInMs -- If the matchmaker uses player latency, include a latency
     * value, in milliseconds, for the Region that the game session is currently in. Do
     * not include latency values for any other Region.
     */
    val players: List<Player>? = builder.players
    /**
     * A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one in the form of
     * a UUID. Use this identifier to track the match backfill ticket status and retrieve match
     * results.
     */
    val ticketId: kotlin.String? = builder.ticketId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.StartMatchBackfillRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartMatchBackfillRequest(")
        append("configurationName=$configurationName,")
        append("gameSessionArn=$gameSessionArn,")
        append("players=$players,")
        append("ticketId=$ticketId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationName?.hashCode() ?: 0
        result = 31 * result + (gameSessionArn?.hashCode() ?: 0)
        result = 31 * result + (players?.hashCode() ?: 0)
        result = 31 * result + (ticketId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartMatchBackfillRequest

        if (configurationName != other.configurationName) return false
        if (gameSessionArn != other.gameSessionArn) return false
        if (players != other.players) return false
        if (ticketId != other.ticketId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.StartMatchBackfillRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Name of the matchmaker to use for this request. You can use either the configuration
         * name or ARN value. The ARN of the matchmaker that was used with the original game
         * session is listed in the GameSession object,
         * MatchmakerData property.
         */
        var configurationName: kotlin.String? = null
        /**
         * A unique identifier for the game session. Use the game session ID. When using FlexMatch as a standalone matchmaking
         * solution, this parameter is not needed.
         */
        var gameSessionArn: kotlin.String? = null
        /**
         * Match information on all players that are currently assigned to the game session.
         * This information is used by the matchmaker to find new players and add them to the
         * existing game.
         *
         *
         * PlayerID, PlayerAttributes, Team -- This information is maintained in the
         * GameSession object, MatchmakerData property,
         * for all players who are currently assigned to the game session. The matchmaker
         * data is in JSON syntax, formatted as a string. For more details, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">
         * Match Data.
         *
         * LatencyInMs -- If the matchmaker uses player latency, include a latency
         * value, in milliseconds, for the Region that the game session is currently in. Do
         * not include latency values for any other Region.
         */
        var players: List<Player>? = null
        /**
         * A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one in the form of
         * a UUID. Use this identifier to track the match backfill ticket status and retrieve match
         * results.
         */
        var ticketId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.StartMatchBackfillRequest) : this() {
            this.configurationName = x.configurationName
            this.gameSessionArn = x.gameSessionArn
            this.players = x.players
            this.ticketId = x.ticketId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.StartMatchBackfillRequest = StartMatchBackfillRequest(this)
    }
}
