// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class StartMatchmakingRequest private constructor(builder: Builder) {
    /**
     * Name of the matchmaking configuration to use for this request. Matchmaking
     * configurations must exist in the same Region as this request. You can use either the
     * configuration name or ARN value.
     */
    val configurationName: kotlin.String? = builder.configurationName
    /**
     * Information on each player to be matched. This information must include a player
     * ID, and may contain player attributes and latency data to be used in the matchmaking
     * process. After a successful match, Player objects contain the name of the
     * team the player is assigned to.
     */
    val players: List<Player>? = builder.players
    /**
     * A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one in the form of
     * a UUID. Use this identifier to track the matchmaking ticket status and retrieve match
     * results.
     */
    val ticketId: kotlin.String? = builder.ticketId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.StartMatchmakingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartMatchmakingRequest(")
        append("configurationName=$configurationName,")
        append("players=$players,")
        append("ticketId=$ticketId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationName?.hashCode() ?: 0
        result = 31 * result + (players?.hashCode() ?: 0)
        result = 31 * result + (ticketId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartMatchmakingRequest

        if (configurationName != other.configurationName) return false
        if (players != other.players) return false
        if (ticketId != other.ticketId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.StartMatchmakingRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Name of the matchmaking configuration to use for this request. Matchmaking
         * configurations must exist in the same Region as this request. You can use either the
         * configuration name or ARN value.
         */
        var configurationName: kotlin.String? = null
        /**
         * Information on each player to be matched. This information must include a player
         * ID, and may contain player attributes and latency data to be used in the matchmaking
         * process. After a successful match, Player objects contain the name of the
         * team the player is assigned to.
         */
        var players: List<Player>? = null
        /**
         * A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one in the form of
         * a UUID. Use this identifier to track the matchmaking ticket status and retrieve match
         * results.
         */
        var ticketId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.StartMatchmakingRequest) : this() {
            this.configurationName = x.configurationName
            this.players = x.players
            this.ticketId = x.ticketId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.StartMatchmakingRequest = StartMatchmakingRequest(this)
    }
}
