// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



class TagResourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name
     * (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN)
     * that is assigned to and uniquely identifies the GameLift resource that you want to assign
     * tags to. GameLift resource ARNs are included in the data object for the resource, which
     * can be retrieved by calling a List or Describe operation for the resource type.
     */
    val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * A list of one or more tags to assign to the specified GameLift resource.
     * Tags are developer-defined and structured as key-value pairs.
     * The maximum tag limit may be lower than stated. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources
     * for actual tagging limits.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.TagResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name
         * (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN)
         * that is assigned to and uniquely identifies the GameLift resource that you want to assign
         * tags to. GameLift resource ARNs are included in the data object for the resource, which
         * can be retrieved by calling a List or Describe operation for the resource type.
         */
        var resourceArn: kotlin.String? = null
        /**
         * A list of one or more tags to assign to the specified GameLift resource.
         * Tags are developer-defined and structured as key-value pairs.
         * The maximum tag limit may be lower than stated. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources
         * for actual tagging limits.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.TagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.TagResourceRequest = TagResourceRequest(this)
    }
}
