// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class UpdateFleetCapacityRequest private constructor(builder: Builder) {
    /**
     * The number of EC2 instances you want to maintain in the specified fleet location.
     * This value must fall between the minimum and maximum size limits.
     */
    val desiredInstances: kotlin.Int? = builder.desiredInstances
    /**
     * A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN
     * value.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * The name of a remote location to update fleet capacity settings for, in the form of an
     * AWS Region code such as us-west-2.
     */
    val location: kotlin.String? = builder.location
    /**
     * The maximum number of instances that are allowed in the specified fleet location. If
     * this parameter is not set, the default is 1.
     */
    val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum number of instances that are allowed in the specified fleet location. If
     * this parameter is not set, the default is 0.
     */
    val minSize: kotlin.Int? = builder.minSize

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.UpdateFleetCapacityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFleetCapacityRequest(")
        append("desiredInstances=$desiredInstances,")
        append("fleetId=$fleetId,")
        append("location=$location,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize)")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredInstances ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFleetCapacityRequest

        if (desiredInstances != other.desiredInstances) return false
        if (fleetId != other.fleetId) return false
        if (location != other.location) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.UpdateFleetCapacityRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of EC2 instances you want to maintain in the specified fleet location.
         * This value must fall between the minimum and maximum size limits.
         */
        var desiredInstances: kotlin.Int? = null
        /**
         * A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN
         * value.
         */
        var fleetId: kotlin.String? = null
        /**
         * The name of a remote location to update fleet capacity settings for, in the form of an
         * AWS Region code such as us-west-2.
         */
        var location: kotlin.String? = null
        /**
         * The maximum number of instances that are allowed in the specified fleet location. If
         * this parameter is not set, the default is 1.
         */
        var maxSize: kotlin.Int? = null
        /**
         * The minimum number of instances that are allowed in the specified fleet location. If
         * this parameter is not set, the default is 0.
         */
        var minSize: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.UpdateFleetCapacityRequest) : this() {
            this.desiredInstances = x.desiredInstances
            this.fleetId = x.fleetId
            this.location = x.location
            this.maxSize = x.maxSize
            this.minSize = x.minSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.UpdateFleetCapacityRequest = UpdateFleetCapacityRequest(this)
    }
}
