// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



class UpdateGameServerGroupRequest private constructor(builder: Builder) {
    /**
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the
     * game server group. Method options include the following:
     *
     *
     *
     * SPOT_ONLY - Only Spot Instances are used in the game server group. If Spot
     * Instances are unavailable or not viable for game hosting, the game server group
     * provides no hosting capacity until Spot Instances can again be used. Until then,
     * no new instances are started, and the existing nonviable Spot Instances are
     * terminated (after current gameplay ends) and are not replaced.
     *
     *
     * SPOT_PREFERRED - (default value) Spot Instances are used whenever available in
     * the game server group. If Spot Instances are unavailable, the game server group
     * continues to provide hosting capacity by falling back to On-Demand Instances.
     * Existing nonviable Spot Instances are terminated (after current gameplay ends)
     * and are replaced with new On-Demand Instances.
     *
     *
     * ON_DEMAND_ONLY - Only On-Demand Instances are used in the game
     * server group. No Spot Instances are used, even when available, while this
     * balancing strategy is in force.
     */
    val balancingStrategy: aws.sdk.kotlin.services.gamelift.model.BalancingStrategy? = builder.balancingStrategy
    /**
     * A unique identifier for the game server group. Use either the GameServerGroup name or ARN value.
     */
    val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * A flag that indicates whether instances in the game server group are protected
     * from early termination. Unprotected instances that have active game servers running might
     * be terminated during a scale-down event, causing players to be dropped from the game.
     * Protected instances cannot be terminated while there are active game servers running except
     * in the event of a forced game server group deletion (see ). An exception to this is with Spot
     * Instances, which can be terminated by AWS regardless of protection status. This property is set to NO_PROTECTION by default.
     */
    val gameServerProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.GameServerProtectionPolicy? = builder.gameServerProtectionPolicy
    /**
     * An updated list of EC2 instance types to use in the Auto Scaling group. The instance
     * definitions must specify at least two different instance types that are supported by
     * GameLift FleetIQ. This updated list replaces the entire current list of instance definitions for
     * the game server group. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance
     * Types in the Amazon EC2 User Guide. You can optionally
     * specify capacity weighting for each instance type. If no weight value is specified for
     * an instance type, it is set to the default value "1". For more information about
     * capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for
     * Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide.
     */
    val instanceDefinitions: List<InstanceDefinition>? = builder.instanceDefinitions
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) for an IAM role that
     * allows Amazon GameLift to access your EC2 Auto Scaling groups.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.UpdateGameServerGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGameServerGroupRequest(")
        append("balancingStrategy=$balancingStrategy,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("gameServerProtectionPolicy=$gameServerProtectionPolicy,")
        append("instanceDefinitions=$instanceDefinitions,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = balancingStrategy?.hashCode() ?: 0
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (gameServerProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (instanceDefinitions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateGameServerGroupRequest

        if (balancingStrategy != other.balancingStrategy) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (gameServerProtectionPolicy != other.gameServerProtectionPolicy) return false
        if (instanceDefinitions != other.instanceDefinitions) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.UpdateGameServerGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the
         * game server group. Method options include the following:
         *
         *
         *
         * SPOT_ONLY - Only Spot Instances are used in the game server group. If Spot
         * Instances are unavailable or not viable for game hosting, the game server group
         * provides no hosting capacity until Spot Instances can again be used. Until then,
         * no new instances are started, and the existing nonviable Spot Instances are
         * terminated (after current gameplay ends) and are not replaced.
         *
         *
         * SPOT_PREFERRED - (default value) Spot Instances are used whenever available in
         * the game server group. If Spot Instances are unavailable, the game server group
         * continues to provide hosting capacity by falling back to On-Demand Instances.
         * Existing nonviable Spot Instances are terminated (after current gameplay ends)
         * and are replaced with new On-Demand Instances.
         *
         *
         * ON_DEMAND_ONLY - Only On-Demand Instances are used in the game
         * server group. No Spot Instances are used, even when available, while this
         * balancing strategy is in force.
         */
        var balancingStrategy: aws.sdk.kotlin.services.gamelift.model.BalancingStrategy? = null
        /**
         * A unique identifier for the game server group. Use either the GameServerGroup name or ARN value.
         */
        var gameServerGroupName: kotlin.String? = null
        /**
         * A flag that indicates whether instances in the game server group are protected
         * from early termination. Unprotected instances that have active game servers running might
         * be terminated during a scale-down event, causing players to be dropped from the game.
         * Protected instances cannot be terminated while there are active game servers running except
         * in the event of a forced game server group deletion (see ). An exception to this is with Spot
         * Instances, which can be terminated by AWS regardless of protection status. This property is set to NO_PROTECTION by default.
         */
        var gameServerProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.GameServerProtectionPolicy? = null
        /**
         * An updated list of EC2 instance types to use in the Auto Scaling group. The instance
         * definitions must specify at least two different instance types that are supported by
         * GameLift FleetIQ. This updated list replaces the entire current list of instance definitions for
         * the game server group. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance
         * Types in the Amazon EC2 User Guide. You can optionally
         * specify capacity weighting for each instance type. If no weight value is specified for
         * an instance type, it is set to the default value "1". For more information about
         * capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for
         * Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide.
         */
        var instanceDefinitions: List<InstanceDefinition>? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) for an IAM role that
         * allows Amazon GameLift to access your EC2 Auto Scaling groups.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.UpdateGameServerGroupRequest) : this() {
            this.balancingStrategy = x.balancingStrategy
            this.gameServerGroupName = x.gameServerGroupName
            this.gameServerProtectionPolicy = x.gameServerProtectionPolicy
            this.instanceDefinitions = x.instanceDefinitions
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.UpdateGameServerGroupRequest = UpdateGameServerGroupRequest(this)
    }
}
