// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class UpdateGameSessionQueueRequest private constructor(builder: Builder) {
    /**
     * Information to be added to all events that are related to this game session queue.
     */
    val customEventData: kotlin.String? = builder.customEventData
    /**
     * A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue.
     * Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference. When updating this list, provide a complete list of destinations.
     */
    val destinations: List<GameSessionQueueDestination>? = builder.destinations
    /**
     * A list of locations where a queue is allowed to place new game sessions. Locations
     * are specified in the form of AWS Region codes, such as us-west-2. If this parameter is
     * not set, game sessions can be placed in any queue location. To remove an existing filter configuration, pass in an empty set.
     */
    val filterConfiguration: aws.sdk.kotlin.services.gamelift.model.FilterConfiguration? = builder.filterConfiguration
    /**
     * A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value.
     */
    val name: kotlin.String? = builder.name
    /**
     * An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html">
     * Setting up notifications for game session placement.
     */
    val notificationTarget: kotlin.String? = builder.notificationTarget
    /**
     * A set of policies that act as a sliding cap on player latency. FleetIQ works to
     * deliver low latency for most players in a game session. These policies ensure that no
     * individual player can be placed into a game with unreasonably high latency. Use multiple
     * policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their
     * maximum allowed latency, starting with the lowest value. When updating policies, provide a complete collection of
     * policies.
     */
    val playerLatencyPolicies: List<PlayerLatencyPolicy>? = builder.playerLatencyPolicies
    /**
     * Custom settings to use when prioritizing destinations and locations for game session placements. This
     * configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly
     * named will be automatically applied at the end of the prioritization process. To remove an existing priority configuration, pass in an empty set.
     */
    val priorityConfiguration: aws.sdk.kotlin.services.gamelift.model.PriorityConfiguration? = builder.priorityConfiguration
    /**
     * The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a TIMED_OUT status.
     */
    val timeoutInSeconds: kotlin.Int? = builder.timeoutInSeconds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionQueueRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGameSessionQueueRequest(")
        append("customEventData=$customEventData,")
        append("destinations=$destinations,")
        append("filterConfiguration=$filterConfiguration,")
        append("name=$name,")
        append("notificationTarget=$notificationTarget,")
        append("playerLatencyPolicies=$playerLatencyPolicies,")
        append("priorityConfiguration=$priorityConfiguration,")
        append("timeoutInSeconds=$timeoutInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customEventData?.hashCode() ?: 0
        result = 31 * result + (destinations?.hashCode() ?: 0)
        result = 31 * result + (filterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notificationTarget?.hashCode() ?: 0)
        result = 31 * result + (playerLatencyPolicies?.hashCode() ?: 0)
        result = 31 * result + (priorityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (timeoutInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateGameSessionQueueRequest

        if (customEventData != other.customEventData) return false
        if (destinations != other.destinations) return false
        if (filterConfiguration != other.filterConfiguration) return false
        if (name != other.name) return false
        if (notificationTarget != other.notificationTarget) return false
        if (playerLatencyPolicies != other.playerLatencyPolicies) return false
        if (priorityConfiguration != other.priorityConfiguration) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionQueueRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information to be added to all events that are related to this game session queue.
         */
        var customEventData: kotlin.String? = null
        /**
         * A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue.
         * Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference. When updating this list, provide a complete list of destinations.
         */
        var destinations: List<GameSessionQueueDestination>? = null
        /**
         * A list of locations where a queue is allowed to place new game sessions. Locations
         * are specified in the form of AWS Region codes, such as us-west-2. If this parameter is
         * not set, game sessions can be placed in any queue location. To remove an existing filter configuration, pass in an empty set.
         */
        var filterConfiguration: aws.sdk.kotlin.services.gamelift.model.FilterConfiguration? = null
        /**
         * A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value.
         */
        var name: kotlin.String? = null
        /**
         * An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html">
         * Setting up notifications for game session placement.
         */
        var notificationTarget: kotlin.String? = null
        /**
         * A set of policies that act as a sliding cap on player latency. FleetIQ works to
         * deliver low latency for most players in a game session. These policies ensure that no
         * individual player can be placed into a game with unreasonably high latency. Use multiple
         * policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their
         * maximum allowed latency, starting with the lowest value. When updating policies, provide a complete collection of
         * policies.
         */
        var playerLatencyPolicies: List<PlayerLatencyPolicy>? = null
        /**
         * Custom settings to use when prioritizing destinations and locations for game session placements. This
         * configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly
         * named will be automatically applied at the end of the prioritization process. To remove an existing priority configuration, pass in an empty set.
         */
        var priorityConfiguration: aws.sdk.kotlin.services.gamelift.model.PriorityConfiguration? = null
        /**
         * The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a TIMED_OUT status.
         */
        var timeoutInSeconds: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionQueueRequest) : this() {
            this.customEventData = x.customEventData
            this.destinations = x.destinations
            this.filterConfiguration = x.filterConfiguration
            this.name = x.name
            this.notificationTarget = x.notificationTarget
            this.playerLatencyPolicies = x.playerLatencyPolicies
            this.priorityConfiguration = x.priorityConfiguration
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionQueueRequest = UpdateGameSessionQueueRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.FilterConfiguration] inside the given [block]
         */
        fun filterConfiguration(block: aws.sdk.kotlin.services.gamelift.model.FilterConfiguration.Builder.() -> kotlin.Unit) {
            this.filterConfiguration = aws.sdk.kotlin.services.gamelift.model.FilterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.PriorityConfiguration] inside the given [block]
         */
        fun priorityConfiguration(block: aws.sdk.kotlin.services.gamelift.model.PriorityConfiguration.Builder.() -> kotlin.Unit) {
            this.priorityConfiguration = aws.sdk.kotlin.services.gamelift.model.PriorityConfiguration.invoke(block)
        }
    }
}
