// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents an authorization for a VPC peering connection between the VPC for an
 * Amazon GameLift fleet and another VPC on an account you have access to. This authorization
 * must exist and be valid for the peering connection to be established. Authorizations are
 * valid for 24 hours after they are issued.
 *
 * Related actions
 *
 *
 * CreateVpcPeeringAuthorization |
 * DescribeVpcPeeringAuthorizations |
 * DeleteVpcPeeringAuthorization |
 * CreateVpcPeeringConnection |
 * DescribeVpcPeeringConnections |
 * DeleteVpcPeeringConnection |
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task
 */
class VpcPeeringAuthorization private constructor(builder: Builder) {
    /**
     * Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Time stamp indicating when this authorization expires (24 hours after issuance).
     * Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val expirationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationTime
    /**
     * A unique identifier for the AWS account that you use to manage your GameLift fleet.
     * You can find your Account ID in the AWS Management Console under account settings.
     */
    val gameLiftAwsAccountId: kotlin.String? = builder.gameLiftAwsAccountId
    /**
     *
     */
    val peerVpcAwsAccountId: kotlin.String? = builder.peerVpcAwsAccountId
    /**
     * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The
     * VPC must be in the same Region as your fleet. To look up a VPC ID, use the
     * <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard in the AWS Management Console.
     * Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets.
     */
    val peerVpcId: kotlin.String? = builder.peerVpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.VpcPeeringAuthorization = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcPeeringAuthorization(")
        append("creationTime=$creationTime,")
        append("expirationTime=$expirationTime,")
        append("gameLiftAwsAccountId=$gameLiftAwsAccountId,")
        append("peerVpcAwsAccountId=$peerVpcAwsAccountId,")
        append("peerVpcId=$peerVpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (gameLiftAwsAccountId?.hashCode() ?: 0)
        result = 31 * result + (peerVpcAwsAccountId?.hashCode() ?: 0)
        result = 31 * result + (peerVpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcPeeringAuthorization

        if (creationTime != other.creationTime) return false
        if (expirationTime != other.expirationTime) return false
        if (gameLiftAwsAccountId != other.gameLiftAwsAccountId) return false
        if (peerVpcAwsAccountId != other.peerVpcAwsAccountId) return false
        if (peerVpcId != other.peerVpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.VpcPeeringAuthorization = Builder(this).apply(block).build()

    class Builder {
        /**
         * Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Time stamp indicating when this authorization expires (24 hours after issuance).
         * Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var expirationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique identifier for the AWS account that you use to manage your GameLift fleet.
         * You can find your Account ID in the AWS Management Console under account settings.
         */
        var gameLiftAwsAccountId: kotlin.String? = null
        /**
         *
         */
        var peerVpcAwsAccountId: kotlin.String? = null
        /**
         * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The
         * VPC must be in the same Region as your fleet. To look up a VPC ID, use the
         * <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard in the AWS Management Console.
         * Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets.
         */
        var peerVpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.VpcPeeringAuthorization) : this() {
            this.creationTime = x.creationTime
            this.expirationTime = x.expirationTime
            this.gameLiftAwsAccountId = x.gameLiftAwsAccountId
            this.peerVpcAwsAccountId = x.peerVpcAwsAccountId
            this.peerVpcId = x.peerVpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.VpcPeeringAuthorization = VpcPeeringAuthorization(this)
    }
}
