// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.paginators

import aws.sdk.kotlin.services.gamelift.GameLiftClient
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetCapacityRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetCapacityResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetEventsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetEventsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetUtilizationRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetUtilizationResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerInstancesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerInstancesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionQueuesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionQueuesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeInstancesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeInstancesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingConfigurationsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingConfigurationsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingRuleSetsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingRuleSetsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesResponse
import aws.sdk.kotlin.services.gamelift.model.ListAliasesRequest
import aws.sdk.kotlin.services.gamelift.model.ListAliasesResponse
import aws.sdk.kotlin.services.gamelift.model.ListBuildsRequest
import aws.sdk.kotlin.services.gamelift.model.ListBuildsResponse
import aws.sdk.kotlin.services.gamelift.model.ListFleetsRequest
import aws.sdk.kotlin.services.gamelift.model.ListFleetsResponse
import aws.sdk.kotlin.services.gamelift.model.ListGameServerGroupsRequest
import aws.sdk.kotlin.services.gamelift.model.ListGameServerGroupsResponse
import aws.sdk.kotlin.services.gamelift.model.ListGameServersRequest
import aws.sdk.kotlin.services.gamelift.model.ListGameServersResponse
import aws.sdk.kotlin.services.gamelift.model.ListScriptsRequest
import aws.sdk.kotlin.services.gamelift.model.ListScriptsResponse
import aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeFleetAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetAttributesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetAttributesResponse]
 */
fun GameLiftClient.describeFleetAttributesPaginated(initialRequest: DescribeFleetAttributesRequest): Flow<DescribeFleetAttributesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetAttributesPaginated.describeFleetAttributes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetAttributesResponse]
 */
fun GameLiftClient.describeFleetAttributesPaginated(block: DescribeFleetAttributesRequest.Builder.() -> Unit): Flow<DescribeFleetAttributesResponse> =
    describeFleetAttributesPaginated(DescribeFleetAttributesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFleetCapacityResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetCapacityRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetCapacityResponse]
 */
fun GameLiftClient.describeFleetCapacityPaginated(initialRequest: DescribeFleetCapacityRequest): Flow<DescribeFleetCapacityResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetCapacityPaginated.describeFleetCapacity(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetCapacityResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetCapacityResponse]
 */
fun GameLiftClient.describeFleetCapacityPaginated(block: DescribeFleetCapacityRequest.Builder.() -> Unit): Flow<DescribeFleetCapacityResponse> =
    describeFleetCapacityPaginated(DescribeFleetCapacityRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFleetEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetEventsResponse]
 */
fun GameLiftClient.describeFleetEventsPaginated(initialRequest: DescribeFleetEventsRequest): Flow<DescribeFleetEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetEventsPaginated.describeFleetEvents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetEventsResponse]
 */
fun GameLiftClient.describeFleetEventsPaginated(block: DescribeFleetEventsRequest.Builder.() -> Unit): Flow<DescribeFleetEventsResponse> =
    describeFleetEventsPaginated(DescribeFleetEventsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFleetLocationAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetLocationAttributesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetLocationAttributesResponse]
 */
fun GameLiftClient.describeFleetLocationAttributesPaginated(initialRequest: DescribeFleetLocationAttributesRequest): Flow<DescribeFleetLocationAttributesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetLocationAttributesPaginated.describeFleetLocationAttributes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetLocationAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetLocationAttributesResponse]
 */
fun GameLiftClient.describeFleetLocationAttributesPaginated(block: DescribeFleetLocationAttributesRequest.Builder.() -> Unit): Flow<DescribeFleetLocationAttributesResponse> =
    describeFleetLocationAttributesPaginated(DescribeFleetLocationAttributesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFleetUtilizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetUtilizationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetUtilizationResponse]
 */
fun GameLiftClient.describeFleetUtilizationPaginated(initialRequest: DescribeFleetUtilizationRequest): Flow<DescribeFleetUtilizationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetUtilizationPaginated.describeFleetUtilization(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetUtilizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetUtilizationResponse]
 */
fun GameLiftClient.describeFleetUtilizationPaginated(block: DescribeFleetUtilizationRequest.Builder.() -> Unit): Flow<DescribeFleetUtilizationResponse> =
    describeFleetUtilizationPaginated(DescribeFleetUtilizationRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeGameServerInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGameServerInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameServerInstancesResponse]
 */
fun GameLiftClient.describeGameServerInstancesPaginated(initialRequest: DescribeGameServerInstancesRequest): Flow<DescribeGameServerInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeGameServerInstancesPaginated.describeGameServerInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGameServerInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameServerInstancesResponse]
 */
fun GameLiftClient.describeGameServerInstancesPaginated(block: DescribeGameServerInstancesRequest.Builder.() -> Unit): Flow<DescribeGameServerInstancesResponse> =
    describeGameServerInstancesPaginated(DescribeGameServerInstancesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeGameSessionDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGameSessionDetailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionDetailsResponse]
 */
fun GameLiftClient.describeGameSessionDetailsPaginated(initialRequest: DescribeGameSessionDetailsRequest): Flow<DescribeGameSessionDetailsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeGameSessionDetailsPaginated.describeGameSessionDetails(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGameSessionDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionDetailsResponse]
 */
fun GameLiftClient.describeGameSessionDetailsPaginated(block: DescribeGameSessionDetailsRequest.Builder.() -> Unit): Flow<DescribeGameSessionDetailsResponse> =
    describeGameSessionDetailsPaginated(DescribeGameSessionDetailsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeGameSessionQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGameSessionQueuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionQueuesResponse]
 */
fun GameLiftClient.describeGameSessionQueuesPaginated(initialRequest: DescribeGameSessionQueuesRequest): Flow<DescribeGameSessionQueuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeGameSessionQueuesPaginated.describeGameSessionQueues(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGameSessionQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionQueuesResponse]
 */
fun GameLiftClient.describeGameSessionQueuesPaginated(block: DescribeGameSessionQueuesRequest.Builder.() -> Unit): Flow<DescribeGameSessionQueuesResponse> =
    describeGameSessionQueuesPaginated(DescribeGameSessionQueuesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeGameSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGameSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionsResponse]
 */
fun GameLiftClient.describeGameSessionsPaginated(initialRequest: DescribeGameSessionsRequest): Flow<DescribeGameSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeGameSessionsPaginated.describeGameSessions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGameSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionsResponse]
 */
fun GameLiftClient.describeGameSessionsPaginated(block: DescribeGameSessionsRequest.Builder.() -> Unit): Flow<DescribeGameSessionsResponse> =
    describeGameSessionsPaginated(DescribeGameSessionsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInstancesResponse]
 */
fun GameLiftClient.describeInstancesPaginated(initialRequest: DescribeInstancesRequest): Flow<DescribeInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeInstancesPaginated.describeInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInstancesResponse]
 */
fun GameLiftClient.describeInstancesPaginated(block: DescribeInstancesRequest.Builder.() -> Unit): Flow<DescribeInstancesResponse> =
    describeInstancesPaginated(DescribeInstancesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeMatchmakingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeMatchmakingConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMatchmakingConfigurationsResponse]
 */
fun GameLiftClient.describeMatchmakingConfigurationsPaginated(initialRequest: DescribeMatchmakingConfigurationsRequest): Flow<DescribeMatchmakingConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeMatchmakingConfigurationsPaginated.describeMatchmakingConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeMatchmakingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMatchmakingConfigurationsResponse]
 */
fun GameLiftClient.describeMatchmakingConfigurationsPaginated(block: DescribeMatchmakingConfigurationsRequest.Builder.() -> Unit): Flow<DescribeMatchmakingConfigurationsResponse> =
    describeMatchmakingConfigurationsPaginated(DescribeMatchmakingConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeMatchmakingRuleSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeMatchmakingRuleSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMatchmakingRuleSetsResponse]
 */
fun GameLiftClient.describeMatchmakingRuleSetsPaginated(initialRequest: DescribeMatchmakingRuleSetsRequest): Flow<DescribeMatchmakingRuleSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeMatchmakingRuleSetsPaginated.describeMatchmakingRuleSets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeMatchmakingRuleSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMatchmakingRuleSetsResponse]
 */
fun GameLiftClient.describeMatchmakingRuleSetsPaginated(block: DescribeMatchmakingRuleSetsRequest.Builder.() -> Unit): Flow<DescribeMatchmakingRuleSetsResponse> =
    describeMatchmakingRuleSetsPaginated(DescribeMatchmakingRuleSetsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribePlayerSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePlayerSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePlayerSessionsResponse]
 */
fun GameLiftClient.describePlayerSessionsPaginated(initialRequest: DescribePlayerSessionsRequest): Flow<DescribePlayerSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePlayerSessionsPaginated.describePlayerSessions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribePlayerSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePlayerSessionsResponse]
 */
fun GameLiftClient.describePlayerSessionsPaginated(block: DescribePlayerSessionsRequest.Builder.() -> Unit): Flow<DescribePlayerSessionsResponse> =
    describePlayerSessionsPaginated(DescribePlayerSessionsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeScalingPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScalingPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingPoliciesResponse]
 */
fun GameLiftClient.describeScalingPoliciesPaginated(initialRequest: DescribeScalingPoliciesRequest): Flow<DescribeScalingPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScalingPoliciesPaginated.describeScalingPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScalingPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingPoliciesResponse]
 */
fun GameLiftClient.describeScalingPoliciesPaginated(block: DescribeScalingPoliciesRequest.Builder.() -> Unit): Flow<DescribeScalingPoliciesResponse> =
    describeScalingPoliciesPaginated(DescribeScalingPoliciesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAliasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
fun GameLiftClient.listAliasesPaginated(initialRequest: ListAliasesRequest): Flow<ListAliasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAliasesPaginated.listAliases(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
fun GameLiftClient.listAliasesPaginated(block: ListAliasesRequest.Builder.() -> Unit): Flow<ListAliasesResponse> =
    listAliasesPaginated(ListAliasesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListBuildsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBuildsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildsResponse]
 */
fun GameLiftClient.listBuildsPaginated(initialRequest: ListBuildsRequest): Flow<ListBuildsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBuildsPaginated.listBuilds(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBuildsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildsResponse]
 */
fun GameLiftClient.listBuildsPaginated(block: ListBuildsRequest.Builder.() -> Unit): Flow<ListBuildsResponse> =
    listBuildsPaginated(ListBuildsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFleetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
fun GameLiftClient.listFleetsPaginated(initialRequest: ListFleetsRequest): Flow<ListFleetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFleetsPaginated.listFleets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
fun GameLiftClient.listFleetsPaginated(block: ListFleetsRequest.Builder.() -> Unit): Flow<ListFleetsResponse> =
    listFleetsPaginated(ListFleetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListGameServerGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGameServerGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGameServerGroupsResponse]
 */
fun GameLiftClient.listGameServerGroupsPaginated(initialRequest: ListGameServerGroupsRequest): Flow<ListGameServerGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGameServerGroupsPaginated.listGameServerGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListGameServerGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGameServerGroupsResponse]
 */
fun GameLiftClient.listGameServerGroupsPaginated(block: ListGameServerGroupsRequest.Builder.() -> Unit): Flow<ListGameServerGroupsResponse> =
    listGameServerGroupsPaginated(ListGameServerGroupsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListGameServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGameServersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGameServersResponse]
 */
fun GameLiftClient.listGameServersPaginated(initialRequest: ListGameServersRequest): Flow<ListGameServersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGameServersPaginated.listGameServers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListGameServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGameServersResponse]
 */
fun GameLiftClient.listGameServersPaginated(block: ListGameServersRequest.Builder.() -> Unit): Flow<ListGameServersResponse> =
    listGameServersPaginated(ListGameServersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListScriptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScriptsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScriptsResponse]
 */
fun GameLiftClient.listScriptsPaginated(initialRequest: ListScriptsRequest): Flow<ListScriptsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScriptsPaginated.listScripts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListScriptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScriptsResponse]
 */
fun GameLiftClient.listScriptsPaginated(block: ListScriptsRequest.Builder.() -> Unit): Flow<ListScriptsResponse> =
    listScriptsPaginated(ListScriptsRequest.Builder().apply(block).build())

/**
 * Paginate over [SearchGameSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchGameSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchGameSessionsResponse]
 */
fun GameLiftClient.searchGameSessionsPaginated(initialRequest: SearchGameSessionsRequest): Flow<SearchGameSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchGameSessionsPaginated.searchGameSessions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchGameSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchGameSessionsResponse]
 */
fun GameLiftClient.searchGameSessionsPaginated(block: SearchGameSessionsRequest.Builder.() -> Unit): Flow<SearchGameSessionsResponse> =
    searchGameSessionsPaginated(SearchGameSessionsRequest.Builder().apply(block).build())
