// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.gamelift.model.AwsCredentials
import aws.sdk.kotlin.services.gamelift.model.Build
import aws.sdk.kotlin.services.gamelift.model.CreateBuildResponse
import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.S3Location
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateBuildOperationDeserializer: HttpDeserialize<CreateBuildResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateBuildResponse {
        if (!response.status.isSuccess()) {
            throwCreateBuildError(context, response)
        }
        val builder = CreateBuildResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateBuildOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateBuildError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "TaggingFailedException" -> TaggingFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateBuildOperationBody(builder: CreateBuildResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUILD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Build"))
    val STORAGELOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StorageLocation"))
    val UPLOADCREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UploadCredentials"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUILD_DESCRIPTOR)
        field(STORAGELOCATION_DESCRIPTOR)
        field(UPLOADCREDENTIALS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUILD_DESCRIPTOR.index -> builder.build = deserializeBuildDocument(deserializer)
                STORAGELOCATION_DESCRIPTOR.index -> builder.storageLocation = deserializeS3LocationDocument(deserializer)
                UPLOADCREDENTIALS_DESCRIPTOR.index -> builder.uploadCredentials = deserializeAwsCredentialsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
