// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetPortSettingsResponse
import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.IpPermission
import aws.sdk.kotlin.services.gamelift.model.LocationUpdateStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeFleetPortSettingsOperationDeserializer: HttpDeserialize<DescribeFleetPortSettingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeFleetPortSettingsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeFleetPortSettingsError(context, response)
        }
        val builder = DescribeFleetPortSettingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFleetPortSettingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeFleetPortSettingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFleetPortSettingsOperationBody(builder: DescribeFleetPortSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FLEETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetArn"))
    val FLEETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FleetId"))
    val INBOUNDPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InboundPermissions"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Location"))
    val UPDATESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UpdateStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FLEETARN_DESCRIPTOR)
        field(FLEETID_DESCRIPTOR)
        field(INBOUNDPERMISSIONS_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(UPDATESTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FLEETARN_DESCRIPTOR.index -> builder.fleetArn = deserializeString()
                FLEETID_DESCRIPTOR.index -> builder.fleetId = deserializeString()
                INBOUNDPERMISSIONS_DESCRIPTOR.index -> builder.inboundPermissions =
                    deserializer.deserializeList(INBOUNDPERMISSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<IpPermission>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIpPermissionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeString()
                UPDATESTATUS_DESCRIPTOR.index -> builder.updateStatus = deserializeString().let { LocationUpdateStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
