// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model



/**
 * Provides options for deleting an archive from an Amazon S3 Glacier vault.
 */
public class DeleteArchiveRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * The ID of the archive to delete.
     */
    public val archiveId: kotlin.String? = requireNotNull(builder.archiveId) { "A non-null value must be provided for archiveId" }
    /**
     * The name of the vault.
     */
    public val vaultName: kotlin.String? = requireNotNull(builder.vaultName) { "A non-null value must be provided for vaultName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.DeleteArchiveRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteArchiveRequest(")
        append("accountId=$accountId,")
        append("archiveId=$archiveId,")
        append("vaultName=$vaultName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (archiveId?.hashCode() ?: 0)
        result = 31 * result + (vaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteArchiveRequest

        if (accountId != other.accountId) return false
        if (archiveId != other.archiveId) return false
        if (vaultName != other.vaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.DeleteArchiveRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The ID of the archive to delete.
         */
        public var archiveId: kotlin.String? = null
        /**
         * The name of the vault.
         */
        public var vaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.DeleteArchiveRequest) : this() {
            this.accountId = x.accountId
            this.archiveId = x.archiveId
            this.vaultName = x.vaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.DeleteArchiveRequest = DeleteArchiveRequest(this)
    }
}
