// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model



/**
 * Contains the Amazon S3 Glacier response to your request.
 */
public class GetVaultLockResponse private constructor(builder: Builder) {
    /**
     * The UTC date and time at which the vault lock was put into the `InProgress` state.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The UTC date and time at which the lock ID expires. This value can be `null` if the vault lock is in a `Locked` state.
     */
    public val expirationDate: kotlin.String? = builder.expirationDate
    /**
     * The vault lock policy as a JSON string, which uses "\" as an escape character.
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The state of the vault lock. `InProgress` or `Locked`.
     */
    public val state: kotlin.String? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.GetVaultLockResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetVaultLockResponse(")
        append("creationDate=$creationDate,")
        append("expirationDate=$expirationDate,")
        append("policy=$policy,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetVaultLockResponse

        if (creationDate != other.creationDate) return false
        if (expirationDate != other.expirationDate) return false
        if (policy != other.policy) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.GetVaultLockResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The UTC date and time at which the vault lock was put into the `InProgress` state.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The UTC date and time at which the lock ID expires. This value can be `null` if the vault lock is in a `Locked` state.
         */
        public var expirationDate: kotlin.String? = null
        /**
         * The vault lock policy as a JSON string, which uses "\" as an escape character.
         */
        public var policy: kotlin.String? = null
        /**
         * The state of the vault lock. `InProgress` or `Locked`.
         */
        public var state: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.GetVaultLockResponse) : this() {
            this.creationDate = x.creationDate
            this.expirationDate = x.expirationDate
            this.policy = x.policy
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.GetVaultLockResponse = GetVaultLockResponse(this)
    }
}
