// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model



/**
 * Describes the options for a range inventory retrieval job.
 */
public class InventoryRetrievalJobDescription private constructor(builder: Builder) {
    /**
     * The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example `2013-03-20T17:03:43Z`.
     */
    public val endDate: kotlin.String? = builder.endDate
    /**
     * The output format for the vault inventory list, which is set by the **InitiateJob** request when initiating a job to retrieve a vault inventory. Valid values are `CSV` and `JSON`.
     */
    public val format: kotlin.String? = builder.format
    /**
     * The maximum number of inventory items returned per vault inventory retrieval request. This limit is set when initiating the job with the a **InitiateJob** request.
     */
    public val limit: kotlin.String? = builder.limit
    /**
     * An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new **InitiateJob** request to obtain additional inventory items. If there are no more inventory items, this value is `null`. For more information, see [ Range Inventory Retrieval](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering).
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example `2013-03-20T17:03:43Z`.
     */
    public val startDate: kotlin.String? = builder.startDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.InventoryRetrievalJobDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InventoryRetrievalJobDescription(")
        append("endDate=$endDate,")
        append("format=$format,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("startDate=$startDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (limit?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InventoryRetrievalJobDescription

        if (endDate != other.endDate) return false
        if (format != other.format) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (startDate != other.startDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.InventoryRetrievalJobDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example `2013-03-20T17:03:43Z`.
         */
        public var endDate: kotlin.String? = null
        /**
         * The output format for the vault inventory list, which is set by the **InitiateJob** request when initiating a job to retrieve a vault inventory. Valid values are `CSV` and `JSON`.
         */
        public var format: kotlin.String? = null
        /**
         * The maximum number of inventory items returned per vault inventory retrieval request. This limit is set when initiating the job with the a **InitiateJob** request.
         */
        public var limit: kotlin.String? = null
        /**
         * An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new **InitiateJob** request to obtain additional inventory items. If there are no more inventory items, this value is `null`. For more information, see [ Range Inventory Retrieval](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering).
         */
        public var marker: kotlin.String? = null
        /**
         * The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example `2013-03-20T17:03:43Z`.
         */
        public var startDate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.InventoryRetrievalJobDescription) : this() {
            this.endDate = x.endDate
            this.format = x.format
            this.limit = x.limit
            this.marker = x.marker
            this.startDate = x.startDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.InventoryRetrievalJobDescription = InventoryRetrievalJobDescription(this)
    }
}
