// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model



/**
 * Provides options for retrieving a job list for an Amazon S3 Glacier vault.
 */
public class ListJobsRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * The state of the jobs to return. You can specify `true` or `false`.
     */
    public val completed: kotlin.String? = builder.completed
    /**
     * The maximum number of jobs to be returned. The default limit is 50. The number of jobs returned might be fewer than the specified limit, but the number of returned jobs never exceeds the limit.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * An opaque string used for pagination. This value specifies the job at which the listing of jobs should begin. Get the marker value from a previous List Jobs response. You only need to include the marker if you are continuing the pagination of results started in a previous List Jobs request.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The type of job status to return. You can specify the following values: `InProgress`, `Succeeded`, or `Failed`.
     */
    public val statuscode: kotlin.String? = builder.statuscode
    /**
     * The name of the vault.
     */
    public val vaultName: kotlin.String? = requireNotNull(builder.vaultName) { "A non-null value must be provided for vaultName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.ListJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListJobsRequest(")
        append("accountId=$accountId,")
        append("completed=$completed,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("statuscode=$statuscode,")
        append("vaultName=$vaultName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (completed?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (statuscode?.hashCode() ?: 0)
        result = 31 * result + (vaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListJobsRequest

        if (accountId != other.accountId) return false
        if (completed != other.completed) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (statuscode != other.statuscode) return false
        if (vaultName != other.vaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.ListJobsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The state of the jobs to return. You can specify `true` or `false`.
         */
        public var completed: kotlin.String? = null
        /**
         * The maximum number of jobs to be returned. The default limit is 50. The number of jobs returned might be fewer than the specified limit, but the number of returned jobs never exceeds the limit.
         */
        public var limit: kotlin.Int? = null
        /**
         * An opaque string used for pagination. This value specifies the job at which the listing of jobs should begin. Get the marker value from a previous List Jobs response. You only need to include the marker if you are continuing the pagination of results started in a previous List Jobs request.
         */
        public var marker: kotlin.String? = null
        /**
         * The type of job status to return. You can specify the following values: `InProgress`, `Succeeded`, or `Failed`.
         */
        public var statuscode: kotlin.String? = null
        /**
         * The name of the vault.
         */
        public var vaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.ListJobsRequest) : this() {
            this.accountId = x.accountId
            this.completed = x.completed
            this.limit = x.limit
            this.marker = x.marker
            this.statuscode = x.statuscode
            this.vaultName = x.vaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.ListJobsRequest = ListJobsRequest(this)
    }
}
