// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model



/**
 * Provides options for retrieving list of in-progress multipart uploads for an Amazon Glacier vault.
 */
public class ListMultipartUploadsRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * Specifies the maximum number of uploads returned in the response body. If this value is not specified, the List Uploads operation returns up to 50 uploads.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * An opaque string used for pagination. This value specifies the upload at which the listing of uploads should begin. Get the marker value from a previous List Uploads response. You need only include the marker if you are continuing the pagination of results started in a previous List Uploads request.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The name of the vault.
     */
    public val vaultName: kotlin.String? = requireNotNull(builder.vaultName) { "A non-null value must be provided for vaultName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.ListMultipartUploadsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListMultipartUploadsRequest(")
        append("accountId=$accountId,")
        append("limit=$limit,")
        append("marker=$marker,")
        append("vaultName=$vaultName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (vaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListMultipartUploadsRequest

        if (accountId != other.accountId) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (vaultName != other.vaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.ListMultipartUploadsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * Specifies the maximum number of uploads returned in the response body. If this value is not specified, the List Uploads operation returns up to 50 uploads.
         */
        public var limit: kotlin.Int? = null
        /**
         * An opaque string used for pagination. This value specifies the upload at which the listing of uploads should begin. Get the marker value from a previous List Uploads response. You need only include the marker if you are continuing the pagination of results started in a previous List Uploads request.
         */
        public var marker: kotlin.String? = null
        /**
         * The name of the vault.
         */
        public var vaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.ListMultipartUploadsRequest) : this() {
            this.accountId = x.accountId
            this.limit = x.limit
            this.marker = x.marker
            this.vaultName = x.vaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.ListMultipartUploadsRequest = ListMultipartUploadsRequest(this)
    }
}
