// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model



/**
 * Contains the Amazon S3 Glacier response to your request.
 */
public class ListPartsResponse private constructor(builder: Builder) {
    /**
     * The description of the archive that was specified in the Initiate Multipart Upload request.
     */
    public val archiveDescription: kotlin.String? = builder.archiveDescription
    /**
     * The UTC time at which the multipart upload was initiated.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * An opaque string that represents where to continue pagination of the results. You use the marker in a new List Parts request to obtain more jobs in the list. If there are no more parts, this value is `null`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The ID of the upload to which the parts are associated.
     */
    public val multipartUploadId: kotlin.String? = builder.multipartUploadId
    /**
     * The part size in bytes. This is the same value that you specified in the Initiate Multipart Upload request.
     */
    public val partSizeInBytes: kotlin.Long = builder.partSizeInBytes
    /**
     * A list of the part sizes of the multipart upload. Each object in the array contains a `RangeBytes` and `sha256-tree-hash` name/value pair.
     */
    public val parts: List<PartListElement>? = builder.parts
    /**
     * The Amazon Resource Name (ARN) of the vault to which the multipart upload was initiated.
     */
    public val vaultArn: kotlin.String? = builder.vaultArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.ListPartsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPartsResponse(")
        append("archiveDescription=$archiveDescription,")
        append("creationDate=$creationDate,")
        append("marker=$marker,")
        append("multipartUploadId=$multipartUploadId,")
        append("partSizeInBytes=$partSizeInBytes,")
        append("parts=$parts,")
        append("vaultArn=$vaultArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveDescription?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (multipartUploadId?.hashCode() ?: 0)
        result = 31 * result + (partSizeInBytes.hashCode())
        result = 31 * result + (parts?.hashCode() ?: 0)
        result = 31 * result + (vaultArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPartsResponse

        if (archiveDescription != other.archiveDescription) return false
        if (creationDate != other.creationDate) return false
        if (marker != other.marker) return false
        if (multipartUploadId != other.multipartUploadId) return false
        if (partSizeInBytes != other.partSizeInBytes) return false
        if (parts != other.parts) return false
        if (vaultArn != other.vaultArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.ListPartsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the archive that was specified in the Initiate Multipart Upload request.
         */
        public var archiveDescription: kotlin.String? = null
        /**
         * The UTC time at which the multipart upload was initiated.
         */
        public var creationDate: kotlin.String? = null
        /**
         * An opaque string that represents where to continue pagination of the results. You use the marker in a new List Parts request to obtain more jobs in the list. If there are no more parts, this value is `null`.
         */
        public var marker: kotlin.String? = null
        /**
         * The ID of the upload to which the parts are associated.
         */
        public var multipartUploadId: kotlin.String? = null
        /**
         * The part size in bytes. This is the same value that you specified in the Initiate Multipart Upload request.
         */
        public var partSizeInBytes: kotlin.Long = 0L
        /**
         * A list of the part sizes of the multipart upload. Each object in the array contains a `RangeBytes` and `sha256-tree-hash` name/value pair.
         */
        public var parts: List<PartListElement>? = null
        /**
         * The Amazon Resource Name (ARN) of the vault to which the multipart upload was initiated.
         */
        public var vaultArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.ListPartsResponse) : this() {
            this.archiveDescription = x.archiveDescription
            this.creationDate = x.creationDate
            this.marker = x.marker
            this.multipartUploadId = x.multipartUploadId
            this.partSizeInBytes = x.partSizeInBytes
            this.parts = x.parts
            this.vaultArn = x.vaultArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.ListPartsResponse = ListPartsResponse(this)
    }
}
