// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model



/**
 * Provides options to retrieve the vault list owned by the calling user's account. The list provides metadata information for each vault.
 */
public class ListVaultsRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * The maximum number of vaults to be returned. The default limit is 10. The number of vaults returned might be fewer than the specified limit, but the number of returned vaults never exceeds the limit.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * A string used for pagination. The marker specifies the vault ARN after which the listing of vaults should begin.
     */
    public val marker: kotlin.String? = builder.marker

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.ListVaultsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListVaultsRequest(")
        append("accountId=$accountId,")
        append("limit=$limit,")
        append("marker=$marker)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListVaultsRequest

        if (accountId != other.accountId) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.ListVaultsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The maximum number of vaults to be returned. The default limit is 10. The number of vaults returned might be fewer than the specified limit, but the number of returned vaults never exceeds the limit.
         */
        public var limit: kotlin.Int? = null
        /**
         * A string used for pagination. The marker specifies the vault ARN after which the listing of vaults should begin.
         */
        public var marker: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.ListVaultsRequest) : this() {
            this.accountId = x.accountId
            this.limit = x.limit
            this.marker = x.marker
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.ListVaultsRequest = ListVaultsRequest(this)
    }
}
