// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model



/**
 * Contains information about the location in Amazon S3 where the select job results are stored.
 */
public class S3Location private constructor(builder: Builder) {
    /**
     * A list of grants that control access to the staged results.
     */
    public val accessControlList: List<Grant>? = builder.accessControlList
    /**
     * The name of the Amazon S3 bucket where the job results are stored.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The canned access control list (ACL) to apply to the job results.
     */
    public val cannedAcl: aws.sdk.kotlin.services.glacier.model.CannedAcl? = builder.cannedAcl
    /**
     * Contains information about the encryption used to store the job results in Amazon S3.
     */
    public val encryption: aws.sdk.kotlin.services.glacier.model.Encryption? = builder.encryption
    /**
     * The prefix that is prepended to the results for this request.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * The storage class used to store the job results.
     */
    public val storageClass: aws.sdk.kotlin.services.glacier.model.StorageClass? = builder.storageClass
    /**
     * The tag-set that is applied to the job results.
     */
    public val tagging: Map<String, String>? = builder.tagging
    /**
     * A map of metadata to store with the job results in Amazon S3.
     */
    public val userMetadata: Map<String, String>? = builder.userMetadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.S3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("accessControlList=$accessControlList,")
        append("bucketName=$bucketName,")
        append("cannedAcl=$cannedAcl,")
        append("encryption=$encryption,")
        append("prefix=$prefix,")
        append("storageClass=$storageClass,")
        append("tagging=$tagging,")
        append("userMetadata=$userMetadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlList?.hashCode() ?: 0
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (cannedAcl?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (tagging?.hashCode() ?: 0)
        result = 31 * result + (userMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Location

        if (accessControlList != other.accessControlList) return false
        if (bucketName != other.bucketName) return false
        if (cannedAcl != other.cannedAcl) return false
        if (encryption != other.encryption) return false
        if (prefix != other.prefix) return false
        if (storageClass != other.storageClass) return false
        if (tagging != other.tagging) return false
        if (userMetadata != other.userMetadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.S3Location = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of grants that control access to the staged results.
         */
        public var accessControlList: List<Grant>? = null
        /**
         * The name of the Amazon S3 bucket where the job results are stored.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The canned access control list (ACL) to apply to the job results.
         */
        public var cannedAcl: aws.sdk.kotlin.services.glacier.model.CannedAcl? = null
        /**
         * Contains information about the encryption used to store the job results in Amazon S3.
         */
        public var encryption: aws.sdk.kotlin.services.glacier.model.Encryption? = null
        /**
         * The prefix that is prepended to the results for this request.
         */
        public var prefix: kotlin.String? = null
        /**
         * The storage class used to store the job results.
         */
        public var storageClass: aws.sdk.kotlin.services.glacier.model.StorageClass? = null
        /**
         * The tag-set that is applied to the job results.
         */
        public var tagging: Map<String, String>? = null
        /**
         * A map of metadata to store with the job results in Amazon S3.
         */
        public var userMetadata: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.S3Location) : this() {
            this.accessControlList = x.accessControlList
            this.bucketName = x.bucketName
            this.cannedAcl = x.cannedAcl
            this.encryption = x.encryption
            this.prefix = x.prefix
            this.storageClass = x.storageClass
            this.tagging = x.tagging
            this.userMetadata = x.userMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.S3Location = S3Location(this)

        /**
         * construct an [aws.sdk.kotlin.services.glacier.model.Encryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.glacier.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.glacier.model.Encryption.invoke(block)
        }
    }
}
