// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model



/**
 * Contains the Amazon S3 Glacier response to your request.
 *
 * For information about the underlying REST API, see [Upload Archive](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html). For conceptual information, see [Working with Archives in Amazon S3 Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html).
 */
public class UploadArchiveResponse private constructor(builder: Builder) {
    /**
     * The ID of the archive. This value is also included as part of the location.
     */
    public val archiveId: kotlin.String? = builder.archiveId
    /**
     * The checksum of the archive computed by Amazon S3 Glacier.
     */
    public val checksum: kotlin.String? = builder.checksum
    /**
     * The relative URI path of the newly added archive resource.
     */
    public val location: kotlin.String? = builder.location

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.UploadArchiveResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UploadArchiveResponse(")
        append("archiveId=$archiveId,")
        append("checksum=$checksum,")
        append("location=$location)")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveId?.hashCode() ?: 0
        result = 31 * result + (checksum?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UploadArchiveResponse

        if (archiveId != other.archiveId) return false
        if (checksum != other.checksum) return false
        if (location != other.location) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.UploadArchiveResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the archive. This value is also included as part of the location.
         */
        public var archiveId: kotlin.String? = null
        /**
         * The checksum of the archive computed by Amazon S3 Glacier.
         */
        public var checksum: kotlin.String? = null
        /**
         * The relative URI path of the newly added archive resource.
         */
        public var location: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.UploadArchiveResponse) : this() {
            this.archiveId = x.archiveId
            this.checksum = x.checksum
            this.location = x.location
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.UploadArchiveResponse = UploadArchiveResponse(this)
    }
}
