// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.model

import aws.smithy.kotlin.runtime.content.ByteStream

/**
 * Provides options to upload a part of an archive in a multipart upload operation.
 */
public class UploadMultipartPartRequest private constructor(builder: Builder) {
    /**
     * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
     */
    public val accountId: kotlin.String? = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * The data to upload.
     */
    public val body: aws.smithy.kotlin.runtime.content.ByteStream? = builder.body
    /**
     * The SHA256 tree hash of the data being uploaded.
     */
    public val checksum: kotlin.String? = builder.checksum
    /**
     * Identifies the range of bytes in the assembled archive that will be uploaded in this part. Amazon S3 Glacier uses this information to assemble the archive in the proper sequence. The format of this header follows RFC 2616. An example header is Content-Range:bytes 0-4194303&#47;*.
     */
    public val range: kotlin.String? = builder.range
    /**
     * The upload ID of the multipart upload.
     */
    public val uploadId: kotlin.String? = requireNotNull(builder.uploadId) { "A non-null value must be provided for uploadId" }
    /**
     * The name of the vault.
     */
    public val vaultName: kotlin.String? = requireNotNull(builder.vaultName) { "A non-null value must be provided for vaultName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.glacier.model.UploadMultipartPartRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UploadMultipartPartRequest(")
        append("accountId=$accountId,")
        append("body=$body,")
        append("checksum=$checksum,")
        append("range=$range,")
        append("uploadId=$uploadId,")
        append("vaultName=$vaultName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (checksum?.hashCode() ?: 0)
        result = 31 * result + (range?.hashCode() ?: 0)
        result = 31 * result + (uploadId?.hashCode() ?: 0)
        result = 31 * result + (vaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UploadMultipartPartRequest

        if (accountId != other.accountId) return false
        if (body != other.body) return false
        if (checksum != other.checksum) return false
        if (range != other.range) return false
        if (uploadId != other.uploadId) return false
        if (vaultName != other.vaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.glacier.model.UploadMultipartPartRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `AccountId` value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The data to upload.
         */
        public var body: aws.smithy.kotlin.runtime.content.ByteStream? = null
        /**
         * The SHA256 tree hash of the data being uploaded.
         */
        public var checksum: kotlin.String? = null
        /**
         * Identifies the range of bytes in the assembled archive that will be uploaded in this part. Amazon S3 Glacier uses this information to assemble the archive in the proper sequence. The format of this header follows RFC 2616. An example header is Content-Range:bytes 0-4194303&#47;*.
         */
        public var range: kotlin.String? = null
        /**
         * The upload ID of the multipart upload.
         */
        public var uploadId: kotlin.String? = null
        /**
         * The name of the vault.
         */
        public var vaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.glacier.model.UploadMultipartPartRequest) : this() {
            this.accountId = x.accountId
            this.body = x.body
            this.checksum = x.checksum
            this.range = x.range
            this.uploadId = x.uploadId
            this.vaultName = x.vaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.glacier.model.UploadMultipartPartRequest = UploadMultipartPartRequest(this)
    }
}
