// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.paginators

import aws.sdk.kotlin.services.glacier.GlacierClient
import aws.sdk.kotlin.services.glacier.model.DescribeVaultOutput
import aws.sdk.kotlin.services.glacier.model.GlacierJobDescription
import aws.sdk.kotlin.services.glacier.model.ListJobsRequest
import aws.sdk.kotlin.services.glacier.model.ListJobsResponse
import aws.sdk.kotlin.services.glacier.model.ListMultipartUploadsRequest
import aws.sdk.kotlin.services.glacier.model.ListMultipartUploadsResponse
import aws.sdk.kotlin.services.glacier.model.ListPartsRequest
import aws.sdk.kotlin.services.glacier.model.ListPartsResponse
import aws.sdk.kotlin.services.glacier.model.ListVaultsRequest
import aws.sdk.kotlin.services.glacier.model.ListVaultsResponse
import aws.sdk.kotlin.services.glacier.model.PartListElement
import aws.sdk.kotlin.services.glacier.model.UploadListElement
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun GlacierClient.listJobsPaginated(initialRequest: ListJobsRequest): Flow<ListJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listJobsPaginated.listJobs(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun GlacierClient.listJobsPaginated(block: ListJobsRequest.Builder.() -> Unit): Flow<ListJobsResponse> =
    listJobsPaginated(ListJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobsPaginated]
 * to access the nested member [GlacierJobDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GlacierJobDescription]
 */
@JvmName("listJobsResponseGlacierJobDescription")
public fun Flow<ListJobsResponse>.jobList(): Flow<GlacierJobDescription> =
    transform() { response ->
        response.jobList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMultipartUploadsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMultipartUploadsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultipartUploadsResponse]
 */
public fun GlacierClient.listMultipartUploadsPaginated(initialRequest: ListMultipartUploadsRequest): Flow<ListMultipartUploadsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listMultipartUploadsPaginated.listMultipartUploads(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListMultipartUploadsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultipartUploadsResponse]
 */
public fun GlacierClient.listMultipartUploadsPaginated(block: ListMultipartUploadsRequest.Builder.() -> Unit): Flow<ListMultipartUploadsResponse> =
    listMultipartUploadsPaginated(ListMultipartUploadsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMultipartUploadsPaginated]
 * to access the nested member [UploadListElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UploadListElement]
 */
@JvmName("listMultipartUploadsResponseUploadListElement")
public fun Flow<ListMultipartUploadsResponse>.uploadsList(): Flow<UploadListElement> =
    transform() { response ->
        response.uploadsList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPartsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPartsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPartsResponse]
 */
public fun GlacierClient.listPartsPaginated(initialRequest: ListPartsRequest): Flow<ListPartsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listPartsPaginated.listParts(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListPartsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPartsResponse]
 */
public fun GlacierClient.listPartsPaginated(block: ListPartsRequest.Builder.() -> Unit): Flow<ListPartsResponse> =
    listPartsPaginated(ListPartsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPartsPaginated]
 * to access the nested member [PartListElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PartListElement]
 */
@JvmName("listPartsResponsePartListElement")
public fun Flow<ListPartsResponse>.parts(): Flow<PartListElement> =
    transform() { response ->
        response.parts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVaultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVaultsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVaultsResponse]
 */
public fun GlacierClient.listVaultsPaginated(initialRequest: ListVaultsRequest): Flow<ListVaultsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listVaultsPaginated.listVaults(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListVaultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVaultsResponse]
 */
public fun GlacierClient.listVaultsPaginated(block: ListVaultsRequest.Builder.() -> Unit): Flow<ListVaultsResponse> =
    listVaultsPaginated(ListVaultsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVaultsPaginated]
 * to access the nested member [DescribeVaultOutput]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeVaultOutput]
 */
@JvmName("listVaultsResponseDescribeVaultOutput")
public fun Flow<ListVaultsResponse>.vaultList(): Flow<DescribeVaultOutput> =
    transform() { response ->
        response.vaultList?.forEach {
            emit(it)
        }
    }
