// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.transform

import aws.sdk.kotlin.services.glacier.model.CompleteMultipartUploadRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class CompleteMultipartUploadOperationSerializer: HttpSerialize<CompleteMultipartUploadRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CompleteMultipartUploadRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "${input.accountId}".encodeLabel(),
                "vaults",
                "${input.vaultName}".encodeLabel(),
                "multipart-uploads",
                "${input.uploadId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.archiveSize?.isNotEmpty() == true) append("x-amz-archive-size", input.archiveSize)
            if (input.checksum?.isNotEmpty() == true) append("x-amz-sha256-tree-hash", input.checksum)
        }

        return builder
    }
}
