// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.glacier.model.DescribeVaultResponse
import aws.sdk.kotlin.services.glacier.model.GlacierException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeVaultOperationDeserializer: HttpDeserialize<DescribeVaultResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeVaultResponse {
        if (!response.status.isSuccess()) {
            throwDescribeVaultError(context, response)
        }
        val builder = DescribeVaultResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeVaultOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeVaultError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlacierException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GlacierException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeVaultOperationBody(builder: DescribeVaultResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreationDate"))
    val LASTINVENTORYDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastInventoryDate"))
    val NUMBEROFARCHIVES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfArchives"))
    val SIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("SizeInBytes"))
    val VAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VaultARN"))
    val VAULTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VaultName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(LASTINVENTORYDATE_DESCRIPTOR)
        field(NUMBEROFARCHIVES_DESCRIPTOR)
        field(SIZEINBYTES_DESCRIPTOR)
        field(VAULTARN_DESCRIPTOR)
        field(VAULTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString()
                LASTINVENTORYDATE_DESCRIPTOR.index -> builder.lastInventoryDate = deserializeString()
                NUMBEROFARCHIVES_DESCRIPTOR.index -> builder.numberOfArchives = deserializeLong()
                SIZEINBYTES_DESCRIPTOR.index -> builder.sizeInBytes = deserializeLong()
                VAULTARN_DESCRIPTOR.index -> builder.vaultArn = deserializeString()
                VAULTNAME_DESCRIPTOR.index -> builder.vaultName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
