// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.glacier.model.DataRetrievalPolicy
import aws.sdk.kotlin.services.glacier.model.GetDataRetrievalPolicyResponse
import aws.sdk.kotlin.services.glacier.model.GlacierException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDataRetrievalPolicyOperationDeserializer: HttpDeserialize<GetDataRetrievalPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDataRetrievalPolicyResponse {
        if (!response.status.isSuccess()) {
            throwGetDataRetrievalPolicyError(context, response)
        }
        val builder = GetDataRetrievalPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDataRetrievalPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDataRetrievalPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlacierException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GlacierException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDataRetrievalPolicyOperationBody(builder: GetDataRetrievalPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Policy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(POLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                POLICY_DESCRIPTOR.index -> builder.policy = deserializeDataRetrievalPolicyDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
