// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.transform

import aws.sdk.kotlin.services.glacier.model.InitiateJobRequest
import aws.sdk.kotlin.services.glacier.model.JobParameters
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class InitiateJobOperationSerializer: HttpSerialize<InitiateJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: InitiateJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "${input.accountId}".encodeLabel(),
                "vaults",
                "${input.vaultName}".encodeLabel(),
                "jobs",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        if (input.jobParameters != null) {
            val payload = serializeJobParametersPayload(input.jobParameters)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.jobParameters == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
