// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.transform

import aws.sdk.kotlin.services.glacier.model.InitiateVaultLockRequest
import aws.sdk.kotlin.services.glacier.model.VaultLockPolicy
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class InitiateVaultLockOperationSerializer: HttpSerialize<InitiateVaultLockRequest> {
    override suspend fun serialize(context: ExecutionContext, input: InitiateVaultLockRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "${input.accountId}".encodeLabel(),
                "vaults",
                "${input.vaultName}".encodeLabel(),
                "lock-policy",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        if (input.policy != null) {
            val payload = serializeVaultLockPolicyPayload(input.policy)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.policy == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
