// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.glacier.model.GlacierException
import aws.sdk.kotlin.services.glacier.model.ListPartsResponse
import aws.sdk.kotlin.services.glacier.model.PartListElement
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListPartsOperationDeserializer: HttpDeserialize<ListPartsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListPartsResponse {
        if (!response.status.isSuccess()) {
            throwListPartsError(context, response)
        }
        val builder = ListPartsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListPartsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListPartsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlacierException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GlacierException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListPartsOperationBody(builder: ListPartsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARCHIVEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArchiveDescription"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreationDate"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val MULTIPARTUPLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MultipartUploadId"))
    val PARTSIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("PartSizeInBytes"))
    val PARTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Parts"))
    val VAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VaultARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARCHIVEDESCRIPTION_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(MULTIPARTUPLOADID_DESCRIPTOR)
        field(PARTSIZEINBYTES_DESCRIPTOR)
        field(PARTS_DESCRIPTOR)
        field(VAULTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARCHIVEDESCRIPTION_DESCRIPTOR.index -> builder.archiveDescription = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString()
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                MULTIPARTUPLOADID_DESCRIPTOR.index -> builder.multipartUploadId = deserializeString()
                PARTSIZEINBYTES_DESCRIPTOR.index -> builder.partSizeInBytes = deserializeLong()
                PARTS_DESCRIPTOR.index -> builder.parts =
                    deserializer.deserializeList(PARTS_DESCRIPTOR) {
                        val col0 = mutableListOf<PartListElement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePartListElementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VAULTARN_DESCRIPTOR.index -> builder.vaultArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
