// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.transform

import aws.sdk.kotlin.services.glacier.model.SetVaultAccessPolicyRequest
import aws.sdk.kotlin.services.glacier.model.VaultAccessPolicy
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class SetVaultAccessPolicyOperationSerializer: HttpSerialize<SetVaultAccessPolicyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SetVaultAccessPolicyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "${input.accountId}".encodeLabel(),
                "vaults",
                "${input.vaultName}".encodeLabel(),
                "access-policy",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        if (input.policy != null) {
            val payload = serializeVaultAccessPolicyPayload(input.policy)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.policy == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
