// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.glacier.transform

import aws.sdk.kotlin.services.glacier.model.UploadMultipartPartRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class UploadMultipartPartOperationSerializer: HttpSerialize<UploadMultipartPartRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UploadMultipartPartRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "${input.accountId}".encodeLabel(),
                "vaults",
                "${input.vaultName}".encodeLabel(),
                "multipart-uploads",
                "${input.uploadId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.checksum?.isNotEmpty() == true) append("x-amz-sha256-tree-hash", input.checksum)
            if (input.range?.isNotEmpty() == true) append("Content-Range", input.range)
        }

        if (input.body != null) {
            builder.body = input.body.toHttpBody() ?: HttpBody.Empty
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.body == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
