// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



public class DenyCustomRoutingTrafficRequest private constructor(builder: Builder) {
    /**
     * Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint *cannot* receive traffic from a custom routing accelerator. The value is TRUE or FALSE.
     *
     * When set to TRUE, *no* destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.
     *
     * When set to FALSE (or not specified), you *must* specify a list of destination IP addresses that cannot receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.
     *
     * The default value is FALSE.
     */
    public val denyAllTrafficToEndpoint: kotlin.Boolean? = builder.denyAllTrafficToEndpoint
    /**
     * A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the endpoint group.
     */
    public val destinationAddresses: List<String>? = builder.destinationAddresses
    /**
     * A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from receiving traffic.
     */
    public val destinationPorts: List<Int>? = builder.destinationPorts
    /**
     * The Amazon Resource Name (ARN) of the endpoint group.
     */
    public val endpointGroupArn: kotlin.String? = builder.endpointGroupArn
    /**
     * An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
     */
    public val endpointId: kotlin.String? = builder.endpointId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DenyCustomRoutingTrafficRequest(")
        append("denyAllTrafficToEndpoint=$denyAllTrafficToEndpoint,")
        append("destinationAddresses=$destinationAddresses,")
        append("destinationPorts=$destinationPorts,")
        append("endpointGroupArn=$endpointGroupArn,")
        append("endpointId=$endpointId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = denyAllTrafficToEndpoint?.hashCode() ?: 0
        result = 31 * result + (destinationAddresses?.hashCode() ?: 0)
        result = 31 * result + (destinationPorts?.hashCode() ?: 0)
        result = 31 * result + (endpointGroupArn?.hashCode() ?: 0)
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DenyCustomRoutingTrafficRequest

        if (denyAllTrafficToEndpoint != other.denyAllTrafficToEndpoint) return false
        if (destinationAddresses != other.destinationAddresses) return false
        if (destinationPorts != other.destinationPorts) return false
        if (endpointGroupArn != other.endpointGroupArn) return false
        if (endpointId != other.endpointId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint *cannot* receive traffic from a custom routing accelerator. The value is TRUE or FALSE.
         *
         * When set to TRUE, *no* destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.
         *
         * When set to FALSE (or not specified), you *must* specify a list of destination IP addresses that cannot receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.
         *
         * The default value is FALSE.
         */
        public var denyAllTrafficToEndpoint: kotlin.Boolean? = null
        /**
         * A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the endpoint group.
         */
        public var destinationAddresses: List<String>? = null
        /**
         * A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from receiving traffic.
         */
        public var destinationPorts: List<Int>? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint group.
         */
        public var endpointGroupArn: kotlin.String? = null
        /**
         * An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
         */
        public var endpointId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest) : this() {
            this.denyAllTrafficToEndpoint = x.denyAllTrafficToEndpoint
            this.destinationAddresses = x.destinationAddresses
            this.destinationPorts = x.destinationPorts
            this.endpointGroupArn = x.endpointGroupArn
            this.endpointId = x.endpointId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest = DenyCustomRoutingTrafficRequest(this)
    }
}
