// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * The port mappings for a specified endpoint IP address (destination).
 */
public class DestinationPortMapping private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the custom routing accelerator that you have port mappings for.
     */
    public val acceleratorArn: kotlin.String? = builder.acceleratorArn
    /**
     * The IP address/port combinations (sockets) that map to a given destination socket address.
     */
    public val acceleratorSocketAddresses: List<SocketAddress>? = builder.acceleratorSocketAddresses
    /**
     * The endpoint IP address/port combination for traffic received on the accelerator socket address.
     */
    public val destinationSocketAddress: aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress? = builder.destinationSocketAddress
    /**
     * Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
     */
    public val destinationTrafficState: aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingDestinationTrafficState? = builder.destinationTrafficState
    /**
     * The Amazon Resource Name (ARN) of the endpoint group.
     */
    public val endpointGroupArn: kotlin.String? = builder.endpointGroupArn
    /**
     * The Amazon Web Services Region for the endpoint group.
     */
    public val endpointGroupRegion: kotlin.String? = builder.endpointGroupRegion
    /**
     * The ID for the virtual private cloud (VPC) subnet.
     */
    public val endpointId: kotlin.String? = builder.endpointId
    /**
     * The IP address type that an accelerator supports. For a custom routing accelerator, the value must be IPV4.
     */
    public val ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = builder.ipAddressType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.DestinationPortMapping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationPortMapping(")
        append("acceleratorArn=$acceleratorArn,")
        append("acceleratorSocketAddresses=$acceleratorSocketAddresses,")
        append("destinationSocketAddress=$destinationSocketAddress,")
        append("destinationTrafficState=$destinationTrafficState,")
        append("endpointGroupArn=$endpointGroupArn,")
        append("endpointGroupRegion=$endpointGroupRegion,")
        append("endpointId=$endpointId,")
        append("ipAddressType=$ipAddressType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorArn?.hashCode() ?: 0
        result = 31 * result + (acceleratorSocketAddresses?.hashCode() ?: 0)
        result = 31 * result + (destinationSocketAddress?.hashCode() ?: 0)
        result = 31 * result + (destinationTrafficState?.hashCode() ?: 0)
        result = 31 * result + (endpointGroupArn?.hashCode() ?: 0)
        result = 31 * result + (endpointGroupRegion?.hashCode() ?: 0)
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DestinationPortMapping

        if (acceleratorArn != other.acceleratorArn) return false
        if (acceleratorSocketAddresses != other.acceleratorSocketAddresses) return false
        if (destinationSocketAddress != other.destinationSocketAddress) return false
        if (destinationTrafficState != other.destinationTrafficState) return false
        if (endpointGroupArn != other.endpointGroupArn) return false
        if (endpointGroupRegion != other.endpointGroupRegion) return false
        if (endpointId != other.endpointId) return false
        if (ipAddressType != other.ipAddressType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.DestinationPortMapping = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the custom routing accelerator that you have port mappings for.
         */
        public var acceleratorArn: kotlin.String? = null
        /**
         * The IP address/port combinations (sockets) that map to a given destination socket address.
         */
        public var acceleratorSocketAddresses: List<SocketAddress>? = null
        /**
         * The endpoint IP address/port combination for traffic received on the accelerator socket address.
         */
        public var destinationSocketAddress: aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress? = null
        /**
         * Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
         */
        public var destinationTrafficState: aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingDestinationTrafficState? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint group.
         */
        public var endpointGroupArn: kotlin.String? = null
        /**
         * The Amazon Web Services Region for the endpoint group.
         */
        public var endpointGroupRegion: kotlin.String? = null
        /**
         * The ID for the virtual private cloud (VPC) subnet.
         */
        public var endpointId: kotlin.String? = null
        /**
         * The IP address type that an accelerator supports. For a custom routing accelerator, the value must be IPV4.
         */
        public var ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.DestinationPortMapping) : this() {
            this.acceleratorArn = x.acceleratorArn
            this.acceleratorSocketAddresses = x.acceleratorSocketAddresses
            this.destinationSocketAddress = x.destinationSocketAddress
            this.destinationTrafficState = x.destinationTrafficState
            this.endpointGroupArn = x.endpointGroupArn
            this.endpointGroupRegion = x.endpointGroupRegion
            this.endpointId = x.endpointId
            this.ipAddressType = x.ipAddressType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.DestinationPortMapping = DestinationPortMapping(this)

        /**
         * construct an [aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress] inside the given [block]
         */
        public fun destinationSocketAddress(block: aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress.Builder.() -> kotlin.Unit) {
            this.destinationSocketAddress = aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress.invoke(block)
        }
    }
}
