// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.globalaccelerator.model.*
import aws.sdk.kotlin.services.globalaccelerator.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Global Accelerator"
const val ServiceApiVersion: String = "2018-08-08"
const val SdkVersion: String = "0.12.0-beta"

internal class DefaultGlobalAcceleratorClient(override val config: GlobalAcceleratorClient.Config) : GlobalAcceleratorClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     * The listener port range must be large enough to support the number of IP addresses that can be
     * specified in your subnet. The number of ports required is: subnet size times the number
     * of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener
     * port range of at least 255 ports.
     * Note: You must have enough remaining listener ports available to
     * map to the subnet ports, or the call will fail with a LimitExceededException.
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
     * destinations to receive traffic, or to specify individual port mappings that can receive
     * traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic operation.
     */
    override suspend fun addCustomRoutingEndpoints(input: AddCustomRoutingEndpointsRequest): AddCustomRoutingEndpointsResponse {
        val op = SdkHttpOperation.build<AddCustomRoutingEndpointsRequest, AddCustomRoutingEndpointsResponse> {
            serializer = AddCustomRoutingEndpointsOperationSerializer()
            deserializer = AddCustomRoutingEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddCustomRoutingEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Advertises an IPv4 address range that is provisioned for use with your AWS resources
     * through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to
     * the specified addresses starts routing to AWS because of propagation delays.
     * To stop advertising the BYOIP address range, use <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">
     * WithdrawByoipCidr.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    override suspend fun advertiseByoipCidr(input: AdvertiseByoipCidrRequest): AdvertiseByoipCidrResponse {
        val op = SdkHttpOperation.build<AdvertiseByoipCidrRequest, AdvertiseByoipCidrResponse> {
            serializer = AdvertiseByoipCidrOperationSerializer()
            deserializer = AdvertiseByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdvertiseByoipCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic
     * for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a
     * specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports
     * outside of the range that you configured for the endpoint group.
     * After you make changes, you can verify that the updates are complete by checking the status of your
     * accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    override suspend fun allowCustomRoutingTraffic(input: AllowCustomRoutingTrafficRequest): AllowCustomRoutingTrafficResponse {
        val op = SdkHttpOperation.build<AllowCustomRoutingTrafficRequest, AllowCustomRoutingTrafficResponse> {
            serializer = AllowCustomRoutingTrafficOperationSerializer()
            deserializer = AllowCustomRoutingTrafficOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AllowCustomRoutingTraffic"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic
     * to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
     * US West (Oregon) Region to create or update accelerators.
     */
    override suspend fun createAccelerator(input: CreateAcceleratorRequest): CreateAcceleratorResponse {
        val op = SdkHttpOperation.build<CreateAcceleratorRequest, CreateAcceleratorResponse> {
            serializer = CreateAcceleratorOperationSerializer()
            deserializer = CreateAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAccelerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands
     * of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive
     * traffic. To enable all destinations to receive traffic, or to specify individual port
     * mappings that can receive traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic operation.
     * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
     * US West (Oregon) Region to create or update accelerators.
     */
    override suspend fun createCustomRoutingAccelerator(input: CreateCustomRoutingAcceleratorRequest): CreateCustomRoutingAcceleratorResponse {
        val op = SdkHttpOperation.build<CreateCustomRoutingAcceleratorRequest, CreateCustomRoutingAcceleratorResponse> {
            serializer = CreateCustomRoutingAcceleratorOperationSerializer()
            deserializer = CreateCustomRoutingAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomRoutingAccelerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an endpoint group for the specified listener for a custom routing accelerator.
     * An endpoint group is a collection of endpoints in one AWS
     * Region.
     */
    override suspend fun createCustomRoutingEndpointGroup(input: CreateCustomRoutingEndpointGroupRequest): CreateCustomRoutingEndpointGroupResponse {
        val op = SdkHttpOperation.build<CreateCustomRoutingEndpointGroupRequest, CreateCustomRoutingEndpointGroupResponse> {
            serializer = CreateCustomRoutingEndpointGroupOperationSerializer()
            deserializer = CreateCustomRoutingEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomRoutingEndpointGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a listener to process inbound connections from clients to a custom routing accelerator.
     * Connections arrive to assigned static IP addresses on the port range that you specify.
     */
    override suspend fun createCustomRoutingListener(input: CreateCustomRoutingListenerRequest): CreateCustomRoutingListenerResponse {
        val op = SdkHttpOperation.build<CreateCustomRoutingListenerRequest, CreateCustomRoutingListenerResponse> {
            serializer = CreateCustomRoutingListenerOperationSerializer()
            deserializer = CreateCustomRoutingListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomRoutingListener"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one AWS
     * Region. A resource must be valid and active when you add it as an endpoint.
     */
    override suspend fun createEndpointGroup(input: CreateEndpointGroupRequest): CreateEndpointGroupResponse {
        val op = SdkHttpOperation.build<CreateEndpointGroupRequest, CreateEndpointGroupResponse> {
            serializer = CreateEndpointGroupOperationSerializer()
            deserializer = CreateEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEndpointGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static
     * IP addresses on a port, port range, or list of port ranges that you specify.
     */
    override suspend fun createListener(input: CreateListenerRequest): CreateListenerResponse {
        val op = SdkHttpOperation.build<CreateListenerRequest, CreateListenerResponse> {
            serializer = CreateListenerOperationSerializer()
            deserializer = CreateListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateListener"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources
     * (listeners and endpoint groups). To disable the accelerator, update the accelerator to set Enabled to false.
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
     * Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses from those ranges.
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and
     * it no longer accepts or routes traffic. However, when you delete an accelerator, you lose the
     * static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them.
     * As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You
     * can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information,
     * see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control in
     * the AWS Global Accelerator Developer Guide.
     */
    override suspend fun deleteAccelerator(input: DeleteAcceleratorRequest): DeleteAcceleratorResponse {
        val op = SdkHttpOperation.build<DeleteAcceleratorRequest, DeleteAcceleratorResponse> {
            serializer = DeleteAcceleratorOperationSerializer()
            deserializer = DeleteAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAccelerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources
     * (listeners and endpoint groups). To disable the accelerator, update the accelerator to set Enabled to false.
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
     * The IP
     * addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and
     * it no longer accepts or routes traffic. However, when you delete an accelerator, you lose the
     * static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them.
     * As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You
     * can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information,
     * see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control in
     * the AWS Global Accelerator Developer Guide.
     */
    override suspend fun deleteCustomRoutingAccelerator(input: DeleteCustomRoutingAcceleratorRequest): DeleteCustomRoutingAcceleratorResponse {
        val op = SdkHttpOperation.build<DeleteCustomRoutingAcceleratorRequest, DeleteCustomRoutingAcceleratorResponse> {
            serializer = DeleteCustomRoutingAcceleratorOperationSerializer()
            deserializer = DeleteCustomRoutingAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomRoutingAccelerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an endpoint group from a listener for a custom routing accelerator.
     */
    override suspend fun deleteCustomRoutingEndpointGroup(input: DeleteCustomRoutingEndpointGroupRequest): DeleteCustomRoutingEndpointGroupResponse {
        val op = SdkHttpOperation.build<DeleteCustomRoutingEndpointGroupRequest, DeleteCustomRoutingEndpointGroupResponse> {
            serializer = DeleteCustomRoutingEndpointGroupOperationSerializer()
            deserializer = DeleteCustomRoutingEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomRoutingEndpointGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a listener for a custom routing accelerator.
     */
    override suspend fun deleteCustomRoutingListener(input: DeleteCustomRoutingListenerRequest): DeleteCustomRoutingListenerResponse {
        val op = SdkHttpOperation.build<DeleteCustomRoutingListenerRequest, DeleteCustomRoutingListenerResponse> {
            serializer = DeleteCustomRoutingListenerOperationSerializer()
            deserializer = DeleteCustomRoutingListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomRoutingListener"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an endpoint group from a listener.
     */
    override suspend fun deleteEndpointGroup(input: DeleteEndpointGroupRequest): DeleteEndpointGroupResponse {
        val op = SdkHttpOperation.build<DeleteEndpointGroupRequest, DeleteEndpointGroupResponse> {
            serializer = DeleteEndpointGroupOperationSerializer()
            deserializer = DeleteEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEndpointGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a listener from an accelerator.
     */
    override suspend fun deleteListener(input: DeleteListenerRequest): DeleteListenerResponse {
        val op = SdkHttpOperation.build<DeleteListenerRequest, DeleteListenerResponse> {
            serializer = DeleteListenerOperationSerializer()
            deserializer = DeleteListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteListener"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic
     * for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a
     * specified list of destination IP addresses and ports. Note that you cannot specify IP addresses
     * or ports outside of the range that you configured for the endpoint group.
     * After you make changes, you can verify that the updates are complete by checking the status of your
     * accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    override suspend fun denyCustomRoutingTraffic(input: DenyCustomRoutingTrafficRequest): DenyCustomRoutingTrafficResponse {
        val op = SdkHttpOperation.build<DenyCustomRoutingTrafficRequest, DenyCustomRoutingTrafficResponse> {
            serializer = DenyCustomRoutingTrafficOperationSerializer()
            deserializer = DenyCustomRoutingTrafficOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DenyCustomRoutingTraffic"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Releases the specified address range that you provisioned to use with your AWS resources
     * through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * Before you can release an address range, you must stop advertising it by using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr and you must not have
     * any accelerators that are using static IP addresses allocated from its address range.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    override suspend fun deprovisionByoipCidr(input: DeprovisionByoipCidrRequest): DeprovisionByoipCidrResponse {
        val op = SdkHttpOperation.build<DeprovisionByoipCidrRequest, DeprovisionByoipCidrResponse> {
            serializer = DeprovisionByoipCidrOperationSerializer()
            deserializer = DeprovisionByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeprovisionByoipCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe an accelerator.
     */
    override suspend fun describeAccelerator(input: DescribeAcceleratorRequest): DescribeAcceleratorResponse {
        val op = SdkHttpOperation.build<DescribeAcceleratorRequest, DescribeAcceleratorResponse> {
            serializer = DescribeAcceleratorOperationSerializer()
            deserializer = DescribeAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccelerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe the attributes of an accelerator.
     */
    override suspend fun describeAcceleratorAttributes(input: DescribeAcceleratorAttributesRequest): DescribeAcceleratorAttributesResponse {
        val op = SdkHttpOperation.build<DescribeAcceleratorAttributesRequest, DescribeAcceleratorAttributesResponse> {
            serializer = DescribeAcceleratorAttributesOperationSerializer()
            deserializer = DescribeAcceleratorAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAcceleratorAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe a custom routing accelerator.
     */
    override suspend fun describeCustomRoutingAccelerator(input: DescribeCustomRoutingAcceleratorRequest): DescribeCustomRoutingAcceleratorResponse {
        val op = SdkHttpOperation.build<DescribeCustomRoutingAcceleratorRequest, DescribeCustomRoutingAcceleratorResponse> {
            serializer = DescribeCustomRoutingAcceleratorOperationSerializer()
            deserializer = DescribeCustomRoutingAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomRoutingAccelerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe the attributes of a custom routing accelerator.
     */
    override suspend fun describeCustomRoutingAcceleratorAttributes(input: DescribeCustomRoutingAcceleratorAttributesRequest): DescribeCustomRoutingAcceleratorAttributesResponse {
        val op = SdkHttpOperation.build<DescribeCustomRoutingAcceleratorAttributesRequest, DescribeCustomRoutingAcceleratorAttributesResponse> {
            serializer = DescribeCustomRoutingAcceleratorAttributesOperationSerializer()
            deserializer = DescribeCustomRoutingAcceleratorAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomRoutingAcceleratorAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe an endpoint group for a custom routing accelerator.
     */
    override suspend fun describeCustomRoutingEndpointGroup(input: DescribeCustomRoutingEndpointGroupRequest): DescribeCustomRoutingEndpointGroupResponse {
        val op = SdkHttpOperation.build<DescribeCustomRoutingEndpointGroupRequest, DescribeCustomRoutingEndpointGroupResponse> {
            serializer = DescribeCustomRoutingEndpointGroupOperationSerializer()
            deserializer = DescribeCustomRoutingEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomRoutingEndpointGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The description of a listener for a custom routing accelerator.
     */
    override suspend fun describeCustomRoutingListener(input: DescribeCustomRoutingListenerRequest): DescribeCustomRoutingListenerResponse {
        val op = SdkHttpOperation.build<DescribeCustomRoutingListenerRequest, DescribeCustomRoutingListenerResponse> {
            serializer = DescribeCustomRoutingListenerOperationSerializer()
            deserializer = DescribeCustomRoutingListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomRoutingListener"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe an endpoint group.
     */
    override suspend fun describeEndpointGroup(input: DescribeEndpointGroupRequest): DescribeEndpointGroupResponse {
        val op = SdkHttpOperation.build<DescribeEndpointGroupRequest, DescribeEndpointGroupResponse> {
            serializer = DescribeEndpointGroupOperationSerializer()
            deserializer = DescribeEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpointGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe a listener.
     */
    override suspend fun describeListener(input: DescribeListenerRequest): DescribeListenerResponse {
        val op = SdkHttpOperation.build<DescribeListenerRequest, DescribeListenerResponse> {
            serializer = DescribeListenerOperationSerializer()
            deserializer = DescribeListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeListener"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the accelerators for an AWS account.
     */
    override suspend fun listAccelerators(input: ListAcceleratorsRequest): ListAcceleratorsResponse {
        val op = SdkHttpOperation.build<ListAcceleratorsRequest, ListAcceleratorsResponse> {
            serializer = ListAcceleratorsOperationSerializer()
            deserializer = ListAcceleratorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccelerators"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the IP address ranges that were specified in calls to <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr, including
     * the current state and a history of state changes.
     */
    override suspend fun listByoipCidrs(input: ListByoipCidrsRequest): ListByoipCidrsResponse {
        val op = SdkHttpOperation.build<ListByoipCidrsRequest, ListByoipCidrsResponse> {
            serializer = ListByoipCidrsOperationSerializer()
            deserializer = ListByoipCidrsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListByoipCidrs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the custom routing accelerators for an AWS account.
     */
    override suspend fun listCustomRoutingAccelerators(input: ListCustomRoutingAcceleratorsRequest): ListCustomRoutingAcceleratorsResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingAcceleratorsRequest, ListCustomRoutingAcceleratorsResponse> {
            serializer = ListCustomRoutingAcceleratorsOperationSerializer()
            deserializer = ListCustomRoutingAcceleratorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingAccelerators"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     */
    override suspend fun listCustomRoutingEndpointGroups(input: ListCustomRoutingEndpointGroupsRequest): ListCustomRoutingEndpointGroupsResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingEndpointGroupsRequest, ListCustomRoutingEndpointGroupsResponse> {
            serializer = ListCustomRoutingEndpointGroupsOperationSerializer()
            deserializer = ListCustomRoutingEndpointGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingEndpointGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the listeners for a custom routing accelerator.
     */
    override suspend fun listCustomRoutingListeners(input: ListCustomRoutingListenersRequest): ListCustomRoutingListenersResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingListenersRequest, ListCustomRoutingListenersResponse> {
            serializer = ListCustomRoutingListenersOperationSerializer()
            deserializer = ListCustomRoutingListenersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingListeners"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance
     * IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator.
     * For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers.
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to
     * your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If you add or remove EC2 instances
     * in your subnet, the port mappings don't change, because the mappings are created when you add the subnet to Global Accelerator.
     * The mappings also include a flag for each destination denoting which destination IP addresses and
     * ports are allowed or denied traffic.
     */
    override suspend fun listCustomRoutingPortMappings(input: ListCustomRoutingPortMappingsRequest): ListCustomRoutingPortMappingsResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingPortMappingsRequest, ListCustomRoutingPortMappingsResponse> {
            serializer = ListCustomRoutingPortMappingsOperationSerializer()
            deserializer = ListCustomRoutingPortMappingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingPortMappings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The
     * response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that
     * span multiple custom routing accelerators in your account, or for scenarios where you only want to
     * list the port mappings for a specific destination instance.
     */
    override suspend fun listCustomRoutingPortMappingsByDestination(input: ListCustomRoutingPortMappingsByDestinationRequest): ListCustomRoutingPortMappingsByDestinationResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingPortMappingsByDestinationRequest, ListCustomRoutingPortMappingsByDestinationResponse> {
            serializer = ListCustomRoutingPortMappingsByDestinationOperationSerializer()
            deserializer = ListCustomRoutingPortMappingsByDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingPortMappingsByDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the endpoint groups that are associated with a listener.
     */
    override suspend fun listEndpointGroups(input: ListEndpointGroupsRequest): ListEndpointGroupsResponse {
        val op = SdkHttpOperation.build<ListEndpointGroupsRequest, ListEndpointGroupsResponse> {
            serializer = ListEndpointGroupsOperationSerializer()
            deserializer = ListEndpointGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEndpointGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the listeners for an accelerator.
     */
    override suspend fun listListeners(input: ListListenersRequest): ListListenersResponse {
        val op = SdkHttpOperation.build<ListListenersRequest, ListListenersResponse> {
            serializer = ListListenersOperationSerializer()
            deserializer = ListListenersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListListeners"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all tags for an accelerator.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provisions an IP address range to use with your AWS resources through bring your own IP
     * addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned,
     * it is ready to be advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
     * AdvertiseByoipCidr.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    override suspend fun provisionByoipCidr(input: ProvisionByoipCidrRequest): ProvisionByoipCidrResponse {
        val op = SdkHttpOperation.build<ProvisionByoipCidrRequest, ProvisionByoipCidrResponse> {
            serializer = ProvisionByoipCidrOperationSerializer()
            deserializer = ProvisionByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ProvisionByoipCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Remove endpoints from a custom routing accelerator.
     */
    override suspend fun removeCustomRoutingEndpoints(input: RemoveCustomRoutingEndpointsRequest): RemoveCustomRoutingEndpointsResponse {
        val op = SdkHttpOperation.build<RemoveCustomRoutingEndpointsRequest, RemoveCustomRoutingEndpointsResponse> {
            serializer = RemoveCustomRoutingEndpointsOperationSerializer()
            deserializer = RemoveCustomRoutingEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveCustomRoutingEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Add tags to an accelerator resource.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value.
     * The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update an accelerator.
     * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
     * US West (Oregon) Region to create or update accelerators.
     */
    override suspend fun updateAccelerator(input: UpdateAcceleratorRequest): UpdateAcceleratorResponse {
        val op = SdkHttpOperation.build<UpdateAcceleratorRequest, UpdateAcceleratorResponse> {
            serializer = UpdateAcceleratorOperationSerializer()
            deserializer = UpdateAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccelerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the attributes for an accelerator.
     */
    override suspend fun updateAcceleratorAttributes(input: UpdateAcceleratorAttributesRequest): UpdateAcceleratorAttributesResponse {
        val op = SdkHttpOperation.build<UpdateAcceleratorAttributesRequest, UpdateAcceleratorAttributesResponse> {
            serializer = UpdateAcceleratorAttributesOperationSerializer()
            deserializer = UpdateAcceleratorAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAcceleratorAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a custom routing accelerator.
     */
    override suspend fun updateCustomRoutingAccelerator(input: UpdateCustomRoutingAcceleratorRequest): UpdateCustomRoutingAcceleratorResponse {
        val op = SdkHttpOperation.build<UpdateCustomRoutingAcceleratorRequest, UpdateCustomRoutingAcceleratorResponse> {
            serializer = UpdateCustomRoutingAcceleratorOperationSerializer()
            deserializer = UpdateCustomRoutingAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCustomRoutingAccelerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the attributes for a custom routing accelerator.
     */
    override suspend fun updateCustomRoutingAcceleratorAttributes(input: UpdateCustomRoutingAcceleratorAttributesRequest): UpdateCustomRoutingAcceleratorAttributesResponse {
        val op = SdkHttpOperation.build<UpdateCustomRoutingAcceleratorAttributesRequest, UpdateCustomRoutingAcceleratorAttributesResponse> {
            serializer = UpdateCustomRoutingAcceleratorAttributesOperationSerializer()
            deserializer = UpdateCustomRoutingAcceleratorAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCustomRoutingAcceleratorAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a listener for a custom routing accelerator.
     */
    override suspend fun updateCustomRoutingListener(input: UpdateCustomRoutingListenerRequest): UpdateCustomRoutingListenerResponse {
        val op = SdkHttpOperation.build<UpdateCustomRoutingListenerRequest, UpdateCustomRoutingListenerResponse> {
            serializer = UpdateCustomRoutingListenerOperationSerializer()
            deserializer = UpdateCustomRoutingListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCustomRoutingListener"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     */
    override suspend fun updateEndpointGroup(input: UpdateEndpointGroupRequest): UpdateEndpointGroupResponse {
        val op = SdkHttpOperation.build<UpdateEndpointGroupRequest, UpdateEndpointGroupResponse> {
            serializer = UpdateEndpointGroupOperationSerializer()
            deserializer = UpdateEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEndpointGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a listener.
     */
    override suspend fun updateListener(input: UpdateListenerRequest): UpdateListenerResponse {
        val op = SdkHttpOperation.build<UpdateListenerRequest, UpdateListenerResponse> {
            serializer = UpdateListenerOperationSerializer()
            deserializer = UpdateListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateListener"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops advertising an address range that is provisioned as an address pool.
     * You can perform this operation at most once every 10 seconds, even if you specify different address
     * ranges each time.
     * It can take a few minutes before traffic to the specified addresses stops routing to AWS because of
     * propagation delays.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    override suspend fun withdrawByoipCidr(input: WithdrawByoipCidrRequest): WithdrawByoipCidrResponse {
        val op = SdkHttpOperation.build<WithdrawByoipCidrRequest, WithdrawByoipCidrResponse> {
            serializer = WithdrawByoipCidrOperationSerializer()
            deserializer = WithdrawByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "WithdrawByoipCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "globalaccelerator"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
