// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.globalaccelerator.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.globalaccelerator.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * <fullname>AWS Global Accelerator</fullname>
 * This is the AWS Global Accelerator API Reference. This guide is for developers who need detailed information about
 * AWS Global Accelerator API actions, data types, and errors. For more information about Global Accelerator features, see the
 * <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/Welcome.html">AWS Global Accelerator Developer Guide.
 * AWS Global Accelerator is a service in which you create accelerators to improve the performance
 * of your applications for local and global users. Depending on the type of accelerator you choose, you can
 * gain additional benefits.
 * By using a standard accelerator, you can improve availability of your internet applications
 * that are used by a global audience. With a standard accelerator, Global Accelerator directs traffic to optimal endpoints over the AWS
 * global network.
 * For other scenarios, you might choose a custom routing accelerator. With a custom routing accelerator, you
 * can use application logic to directly map one or more users to a specific endpoint among many endpoints.
 * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
 * US West (Oregon) Region to create or update accelerators.
 * By default, Global Accelerator provides you with two static IP addresses that you associate with your accelerator. With
 * a standard accelerator, instead of using the
 * IP addresses that Global Accelerator provides, you can configure these entry points to be IPv4 addresses from your own IP address ranges
 * that you bring to Global Accelerator. The static IP addresses are anycast from the AWS edge network. For a standard accelerator,
 * they distribute incoming application traffic across multiple endpoint resources in multiple AWS Regions, which increases
 * the availability of your applications. Endpoints for standard accelerators can be Network Load Balancers, Application Load Balancers,
 * Amazon EC2 instances, or Elastic IP addresses that are located in one AWS Region or multiple Regions. For custom routing
 * accelerators, you map traffic that arrives to the static IP addresses to specific Amazon EC2 servers in endpoints that
 * are virtual private cloud (VPC) subnets.
 * The static IP addresses remain assigned to your accelerator for as long as it exists, even if you
 * disable the accelerator and it no longer accepts or routes traffic. However, when you
 * delete an accelerator, you lose the static IP addresses that
 * are assigned to it, so you can no longer route traffic by using them. You can use
 * IAM policies like tag-based permissions with Global Accelerator to limit the users who have
 * permissions to delete an accelerator. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/access-control-manage-access-tag-policies.html">Tag-based policies.
 * For standard accelerators, Global Accelerator uses the AWS global network to route traffic to the optimal regional endpoint based
 * on health, client location, and policies that you configure. The service reacts instantly to
 * changes in health or configuration to ensure that internet traffic from clients is always
 * directed to healthy endpoints.
 * For a list of the AWS Regions where Global Accelerator and other services are currently supported, see the
 * <a href="https://docs.aws.amazon.com/about-aws/global-infrastructure/regional-product-services/">AWS
 * Region Table.
 * AWS Global Accelerator includes the following components:
 * Static IP addresses
 * Global Accelerator provides you with a set of two static IP addresses that are anycast from the AWS edge
 * network. If you bring your own IP address range to AWS (BYOIP) to use with a standard accelerator, you
 * can instead assign IP addresses from your own pool to use with your accelerator. For more information,
 * see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">
 * Bring your own IP addresses (BYOIP) in AWS Global Accelerator.
 * The IP addresses serve as single fixed entry points for your clients. If you already have Elastic
 * Load Balancing load balancers, Amazon EC2 instances, or Elastic IP address resources set up for your applications,
 * you can easily add those to a standard accelerator in Global Accelerator. This allows Global Accelerator to use static IP addresses
 * to access the resources.
 * The static IP addresses remain assigned to your accelerator for as long as it exists, even
 * if you disable the accelerator and it no longer accepts or routes traffic.
 * However, when you delete an accelerator, you lose the
 * static IP addresses that are assigned to it, so you can no longer route
 * traffic by using them. You can use IAM policies like tag-based permissions
 * with Global Accelerator to delete an accelerator. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/access-control-manage-access-tag-policies.html">Tag-based policies.
 * Accelerator
 * An accelerator directs traffic to endpoints over the AWS global network to improve the
 * performance of your internet applications. Each accelerator includes one or more listeners.
 * There are two types of accelerators:
 * A standard accelerator directs traffic to the optimal AWS endpoint based
 * on several factors, including the user’s location, the health of the endpoint, and the endpoint weights
 * that you configure. This improves the availability and performance of your applications.
 * Endpoints can be Network Load Balancers, Application Load Balancers, Amazon EC2 instances, or Elastic IP addresses.
 * A custom routing accelerator directs traffic to one of possibly thousands of
 * Amazon EC2 instances running in a single or multiple virtual private
 * clouds (VPCs). With custom routing, listener ports are mapped to
 * statically associate port ranges with VPC subnets, which
 * allows Global Accelerator to determine an EC2 instance IP address at the time of
 * connection. By default, all port mapping destinations in a VPC
 * subnet can't receive traffic. You can choose to configure all
 * destinations in the subnet to receive traffic, or to specify
 * individual port mappings that can receive traffic.
 * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-accelerator-types.html">Types of accelerators.
 * DNS name
 * Global Accelerator assigns each accelerator a default Domain Name System (DNS) name, similar to
 * a1234567890abcdef.awsglobalaccelerator.com, that points to
 * the static IP addresses that Global Accelerator assigns to you or that you choose from your
 * own IP address range. Depending on the use
 * case, you can use your accelerator's static IP addresses or DNS name to
 * route traffic to your accelerator, or set up DNS records to route traffic using
 * your own custom domain name.
 * Network zone
 * A network zone services the static IP addresses for your accelerator from a unique IP subnet. Similar to an
 * AWS Availability Zone, a network zone is an isolated unit with its own set of physical infrastructure.
 * When you configure an accelerator, by default, Global Accelerator allocates two IPv4 addresses for it. If one IP address from a
 * network zone becomes unavailable due to IP address blocking by certain client networks, or network
 * disruptions, then client applications can retry on the healthy static IP address from the other isolated
 * network zone.
 * Listener
 * A listener processes inbound connections from clients to Global Accelerator, based on the port (or port range)
 * and protocol (or protocols) that you configure. A listener can be configured for TCP, UDP, or both TCP and UDP protocols. Each
 * listener has one or more endpoint groups associated with it, and traffic is forwarded
 * to endpoints in one of the groups. You associate endpoint groups with listeners by specifying the Regions that you
 * want to distribute traffic to. With a standard accelerator, traffic is distributed to optimal endpoints within the endpoint
 * groups associated with a listener.
 * Endpoint group
 * Each endpoint group is associated with a specific AWS Region. Endpoint groups include one or
 * more endpoints in the Region. With a standard accelerator, you can increase or reduce the percentage of
 * traffic that would be otherwise directed to an endpoint group by adjusting a
 * setting called a traffic dial. The traffic dial lets
 * you easily do performance testing or blue/green deployment testing, for example, for new
 * releases across different AWS Regions.
 * Endpoint
 * An endpoint is a resource that Global Accelerator directs traffic to.
 * Endpoints for standard accelerators can be Network Load Balancers, Application Load Balancers, Amazon EC2 instances, or Elastic IP
 * addresses. An Application Load Balancer endpoint can be internet-facing or internal. Traffic for
 * standard accelerators is routed to endpoints based on the health of the
 * endpoint along with configuration options that you choose, such as endpoint
 * weights. For each endpoint, you can configure weights, which are numbers
 * that you can use to specify the proportion of traffic to route to each one.
 * This can be useful, for example, to do performance testing within a
 * Region.
 * Endpoints for custom routing accelerators are virtual private cloud (VPC) subnets with one
 * or many EC2 instances.
 */
interface GlobalAcceleratorClient : SdkClient {

    override val serviceName: String
        get() = "Global Accelerator"
    /**
     * GlobalAcceleratorClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): GlobalAcceleratorClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultGlobalAcceleratorClient(config)
        }

        operator fun invoke(config: Config): GlobalAcceleratorClient = DefaultGlobalAcceleratorClient(config)

        /**
         * Construct a [GlobalAcceleratorClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): GlobalAcceleratorClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return GlobalAcceleratorClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     * The listener port range must be large enough to support the number of IP addresses that can be
     * specified in your subnet. The number of ports required is: subnet size times the number
     * of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener
     * port range of at least 255 ports.
     * Note: You must have enough remaining listener ports available to
     * map to the subnet ports, or the call will fail with a LimitExceededException.
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
     * destinations to receive traffic, or to specify individual port mappings that can receive
     * traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic operation.
     */
    suspend fun addCustomRoutingEndpoints(input: AddCustomRoutingEndpointsRequest): AddCustomRoutingEndpointsResponse

    /**
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     * The listener port range must be large enough to support the number of IP addresses that can be
     * specified in your subnet. The number of ports required is: subnet size times the number
     * of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener
     * port range of at least 255 ports.
     * Note: You must have enough remaining listener ports available to
     * map to the subnet ports, or the call will fail with a LimitExceededException.
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
     * destinations to receive traffic, or to specify individual port mappings that can receive
     * traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic operation.
     */
    suspend fun addCustomRoutingEndpoints(block: AddCustomRoutingEndpointsRequest.Builder.() -> Unit) = addCustomRoutingEndpoints(AddCustomRoutingEndpointsRequest.Builder().apply(block).build())

    /**
     * Advertises an IPv4 address range that is provisioned for use with your AWS resources
     * through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to
     * the specified addresses starts routing to AWS because of propagation delays.
     * To stop advertising the BYOIP address range, use <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">
     * WithdrawByoipCidr.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    suspend fun advertiseByoipCidr(input: AdvertiseByoipCidrRequest): AdvertiseByoipCidrResponse

    /**
     * Advertises an IPv4 address range that is provisioned for use with your AWS resources
     * through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to
     * the specified addresses starts routing to AWS because of propagation delays.
     * To stop advertising the BYOIP address range, use <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">
     * WithdrawByoipCidr.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    suspend fun advertiseByoipCidr(block: AdvertiseByoipCidrRequest.Builder.() -> Unit) = advertiseByoipCidr(AdvertiseByoipCidrRequest.Builder().apply(block).build())

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic
     * for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a
     * specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports
     * outside of the range that you configured for the endpoint group.
     * After you make changes, you can verify that the updates are complete by checking the status of your
     * accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    suspend fun allowCustomRoutingTraffic(input: AllowCustomRoutingTrafficRequest): AllowCustomRoutingTrafficResponse

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic
     * for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a
     * specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports
     * outside of the range that you configured for the endpoint group.
     * After you make changes, you can verify that the updates are complete by checking the status of your
     * accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    suspend fun allowCustomRoutingTraffic(block: AllowCustomRoutingTrafficRequest.Builder.() -> Unit) = allowCustomRoutingTraffic(AllowCustomRoutingTrafficRequest.Builder().apply(block).build())

    /**
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic
     * to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
     * US West (Oregon) Region to create or update accelerators.
     */
    suspend fun createAccelerator(input: CreateAcceleratorRequest): CreateAcceleratorResponse

    /**
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic
     * to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
     * US West (Oregon) Region to create or update accelerators.
     */
    suspend fun createAccelerator(block: CreateAcceleratorRequest.Builder.() -> Unit) = createAccelerator(CreateAcceleratorRequest.Builder().apply(block).build())

    /**
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands
     * of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive
     * traffic. To enable all destinations to receive traffic, or to specify individual port
     * mappings that can receive traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic operation.
     * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
     * US West (Oregon) Region to create or update accelerators.
     */
    suspend fun createCustomRoutingAccelerator(input: CreateCustomRoutingAcceleratorRequest): CreateCustomRoutingAcceleratorResponse

    /**
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands
     * of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive
     * traffic. To enable all destinations to receive traffic, or to specify individual port
     * mappings that can receive traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic operation.
     * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
     * US West (Oregon) Region to create or update accelerators.
     */
    suspend fun createCustomRoutingAccelerator(block: CreateCustomRoutingAcceleratorRequest.Builder.() -> Unit) = createCustomRoutingAccelerator(CreateCustomRoutingAcceleratorRequest.Builder().apply(block).build())

    /**
     * Create an endpoint group for the specified listener for a custom routing accelerator.
     * An endpoint group is a collection of endpoints in one AWS
     * Region.
     */
    suspend fun createCustomRoutingEndpointGroup(input: CreateCustomRoutingEndpointGroupRequest): CreateCustomRoutingEndpointGroupResponse

    /**
     * Create an endpoint group for the specified listener for a custom routing accelerator.
     * An endpoint group is a collection of endpoints in one AWS
     * Region.
     */
    suspend fun createCustomRoutingEndpointGroup(block: CreateCustomRoutingEndpointGroupRequest.Builder.() -> Unit) = createCustomRoutingEndpointGroup(CreateCustomRoutingEndpointGroupRequest.Builder().apply(block).build())

    /**
     * Create a listener to process inbound connections from clients to a custom routing accelerator.
     * Connections arrive to assigned static IP addresses on the port range that you specify.
     */
    suspend fun createCustomRoutingListener(input: CreateCustomRoutingListenerRequest): CreateCustomRoutingListenerResponse

    /**
     * Create a listener to process inbound connections from clients to a custom routing accelerator.
     * Connections arrive to assigned static IP addresses on the port range that you specify.
     */
    suspend fun createCustomRoutingListener(block: CreateCustomRoutingListenerRequest.Builder.() -> Unit) = createCustomRoutingListener(CreateCustomRoutingListenerRequest.Builder().apply(block).build())

    /**
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one AWS
     * Region. A resource must be valid and active when you add it as an endpoint.
     */
    suspend fun createEndpointGroup(input: CreateEndpointGroupRequest): CreateEndpointGroupResponse

    /**
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one AWS
     * Region. A resource must be valid and active when you add it as an endpoint.
     */
    suspend fun createEndpointGroup(block: CreateEndpointGroupRequest.Builder.() -> Unit) = createEndpointGroup(CreateEndpointGroupRequest.Builder().apply(block).build())

    /**
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static
     * IP addresses on a port, port range, or list of port ranges that you specify.
     */
    suspend fun createListener(input: CreateListenerRequest): CreateListenerResponse

    /**
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static
     * IP addresses on a port, port range, or list of port ranges that you specify.
     */
    suspend fun createListener(block: CreateListenerRequest.Builder.() -> Unit) = createListener(CreateListenerRequest.Builder().apply(block).build())

    /**
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources
     * (listeners and endpoint groups). To disable the accelerator, update the accelerator to set Enabled to false.
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
     * Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses from those ranges.
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and
     * it no longer accepts or routes traffic. However, when you delete an accelerator, you lose the
     * static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them.
     * As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You
     * can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information,
     * see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control in
     * the AWS Global Accelerator Developer Guide.
     */
    suspend fun deleteAccelerator(input: DeleteAcceleratorRequest): DeleteAcceleratorResponse

    /**
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources
     * (listeners and endpoint groups). To disable the accelerator, update the accelerator to set Enabled to false.
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
     * Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses from those ranges.
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and
     * it no longer accepts or routes traffic. However, when you delete an accelerator, you lose the
     * static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them.
     * As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You
     * can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information,
     * see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control in
     * the AWS Global Accelerator Developer Guide.
     */
    suspend fun deleteAccelerator(block: DeleteAcceleratorRequest.Builder.() -> Unit) = deleteAccelerator(DeleteAcceleratorRequest.Builder().apply(block).build())

    /**
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources
     * (listeners and endpoint groups). To disable the accelerator, update the accelerator to set Enabled to false.
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
     * The IP
     * addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and
     * it no longer accepts or routes traffic. However, when you delete an accelerator, you lose the
     * static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them.
     * As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You
     * can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information,
     * see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control in
     * the AWS Global Accelerator Developer Guide.
     */
    suspend fun deleteCustomRoutingAccelerator(input: DeleteCustomRoutingAcceleratorRequest): DeleteCustomRoutingAcceleratorResponse

    /**
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources
     * (listeners and endpoint groups). To disable the accelerator, update the accelerator to set Enabled to false.
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
     * The IP
     * addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and
     * it no longer accepts or routes traffic. However, when you delete an accelerator, you lose the
     * static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them.
     * As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You
     * can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information,
     * see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control in
     * the AWS Global Accelerator Developer Guide.
     */
    suspend fun deleteCustomRoutingAccelerator(block: DeleteCustomRoutingAcceleratorRequest.Builder.() -> Unit) = deleteCustomRoutingAccelerator(DeleteCustomRoutingAcceleratorRequest.Builder().apply(block).build())

    /**
     * Delete an endpoint group from a listener for a custom routing accelerator.
     */
    suspend fun deleteCustomRoutingEndpointGroup(input: DeleteCustomRoutingEndpointGroupRequest): DeleteCustomRoutingEndpointGroupResponse

    /**
     * Delete an endpoint group from a listener for a custom routing accelerator.
     */
    suspend fun deleteCustomRoutingEndpointGroup(block: DeleteCustomRoutingEndpointGroupRequest.Builder.() -> Unit) = deleteCustomRoutingEndpointGroup(DeleteCustomRoutingEndpointGroupRequest.Builder().apply(block).build())

    /**
     * Delete a listener for a custom routing accelerator.
     */
    suspend fun deleteCustomRoutingListener(input: DeleteCustomRoutingListenerRequest): DeleteCustomRoutingListenerResponse

    /**
     * Delete a listener for a custom routing accelerator.
     */
    suspend fun deleteCustomRoutingListener(block: DeleteCustomRoutingListenerRequest.Builder.() -> Unit) = deleteCustomRoutingListener(DeleteCustomRoutingListenerRequest.Builder().apply(block).build())

    /**
     * Delete an endpoint group from a listener.
     */
    suspend fun deleteEndpointGroup(input: DeleteEndpointGroupRequest): DeleteEndpointGroupResponse

    /**
     * Delete an endpoint group from a listener.
     */
    suspend fun deleteEndpointGroup(block: DeleteEndpointGroupRequest.Builder.() -> Unit) = deleteEndpointGroup(DeleteEndpointGroupRequest.Builder().apply(block).build())

    /**
     * Delete a listener from an accelerator.
     */
    suspend fun deleteListener(input: DeleteListenerRequest): DeleteListenerResponse

    /**
     * Delete a listener from an accelerator.
     */
    suspend fun deleteListener(block: DeleteListenerRequest.Builder.() -> Unit) = deleteListener(DeleteListenerRequest.Builder().apply(block).build())

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic
     * for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a
     * specified list of destination IP addresses and ports. Note that you cannot specify IP addresses
     * or ports outside of the range that you configured for the endpoint group.
     * After you make changes, you can verify that the updates are complete by checking the status of your
     * accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    suspend fun denyCustomRoutingTraffic(input: DenyCustomRoutingTrafficRequest): DenyCustomRoutingTrafficResponse

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic
     * for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a
     * specified list of destination IP addresses and ports. Note that you cannot specify IP addresses
     * or ports outside of the range that you configured for the endpoint group.
     * After you make changes, you can verify that the updates are complete by checking the status of your
     * accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    suspend fun denyCustomRoutingTraffic(block: DenyCustomRoutingTrafficRequest.Builder.() -> Unit) = denyCustomRoutingTraffic(DenyCustomRoutingTrafficRequest.Builder().apply(block).build())

    /**
     * Releases the specified address range that you provisioned to use with your AWS resources
     * through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * Before you can release an address range, you must stop advertising it by using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr and you must not have
     * any accelerators that are using static IP addresses allocated from its address range.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    suspend fun deprovisionByoipCidr(input: DeprovisionByoipCidrRequest): DeprovisionByoipCidrResponse

    /**
     * Releases the specified address range that you provisioned to use with your AWS resources
     * through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * Before you can release an address range, you must stop advertising it by using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr and you must not have
     * any accelerators that are using static IP addresses allocated from its address range.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    suspend fun deprovisionByoipCidr(block: DeprovisionByoipCidrRequest.Builder.() -> Unit) = deprovisionByoipCidr(DeprovisionByoipCidrRequest.Builder().apply(block).build())

    /**
     * Describe an accelerator.
     */
    suspend fun describeAccelerator(input: DescribeAcceleratorRequest): DescribeAcceleratorResponse

    /**
     * Describe an accelerator.
     */
    suspend fun describeAccelerator(block: DescribeAcceleratorRequest.Builder.() -> Unit) = describeAccelerator(DescribeAcceleratorRequest.Builder().apply(block).build())

    /**
     * Describe the attributes of an accelerator.
     */
    suspend fun describeAcceleratorAttributes(input: DescribeAcceleratorAttributesRequest): DescribeAcceleratorAttributesResponse

    /**
     * Describe the attributes of an accelerator.
     */
    suspend fun describeAcceleratorAttributes(block: DescribeAcceleratorAttributesRequest.Builder.() -> Unit) = describeAcceleratorAttributes(DescribeAcceleratorAttributesRequest.Builder().apply(block).build())

    /**
     * Describe a custom routing accelerator.
     */
    suspend fun describeCustomRoutingAccelerator(input: DescribeCustomRoutingAcceleratorRequest): DescribeCustomRoutingAcceleratorResponse

    /**
     * Describe a custom routing accelerator.
     */
    suspend fun describeCustomRoutingAccelerator(block: DescribeCustomRoutingAcceleratorRequest.Builder.() -> Unit) = describeCustomRoutingAccelerator(DescribeCustomRoutingAcceleratorRequest.Builder().apply(block).build())

    /**
     * Describe the attributes of a custom routing accelerator.
     */
    suspend fun describeCustomRoutingAcceleratorAttributes(input: DescribeCustomRoutingAcceleratorAttributesRequest): DescribeCustomRoutingAcceleratorAttributesResponse

    /**
     * Describe the attributes of a custom routing accelerator.
     */
    suspend fun describeCustomRoutingAcceleratorAttributes(block: DescribeCustomRoutingAcceleratorAttributesRequest.Builder.() -> Unit) = describeCustomRoutingAcceleratorAttributes(DescribeCustomRoutingAcceleratorAttributesRequest.Builder().apply(block).build())

    /**
     * Describe an endpoint group for a custom routing accelerator.
     */
    suspend fun describeCustomRoutingEndpointGroup(input: DescribeCustomRoutingEndpointGroupRequest): DescribeCustomRoutingEndpointGroupResponse

    /**
     * Describe an endpoint group for a custom routing accelerator.
     */
    suspend fun describeCustomRoutingEndpointGroup(block: DescribeCustomRoutingEndpointGroupRequest.Builder.() -> Unit) = describeCustomRoutingEndpointGroup(DescribeCustomRoutingEndpointGroupRequest.Builder().apply(block).build())

    /**
     * The description of a listener for a custom routing accelerator.
     */
    suspend fun describeCustomRoutingListener(input: DescribeCustomRoutingListenerRequest): DescribeCustomRoutingListenerResponse

    /**
     * The description of a listener for a custom routing accelerator.
     */
    suspend fun describeCustomRoutingListener(block: DescribeCustomRoutingListenerRequest.Builder.() -> Unit) = describeCustomRoutingListener(DescribeCustomRoutingListenerRequest.Builder().apply(block).build())

    /**
     * Describe an endpoint group.
     */
    suspend fun describeEndpointGroup(input: DescribeEndpointGroupRequest): DescribeEndpointGroupResponse

    /**
     * Describe an endpoint group.
     */
    suspend fun describeEndpointGroup(block: DescribeEndpointGroupRequest.Builder.() -> Unit) = describeEndpointGroup(DescribeEndpointGroupRequest.Builder().apply(block).build())

    /**
     * Describe a listener.
     */
    suspend fun describeListener(input: DescribeListenerRequest): DescribeListenerResponse

    /**
     * Describe a listener.
     */
    suspend fun describeListener(block: DescribeListenerRequest.Builder.() -> Unit) = describeListener(DescribeListenerRequest.Builder().apply(block).build())

    /**
     * List the accelerators for an AWS account.
     */
    suspend fun listAccelerators(input: ListAcceleratorsRequest): ListAcceleratorsResponse

    /**
     * List the accelerators for an AWS account.
     */
    suspend fun listAccelerators(block: ListAcceleratorsRequest.Builder.() -> Unit) = listAccelerators(ListAcceleratorsRequest.Builder().apply(block).build())

    /**
     * Lists the IP address ranges that were specified in calls to <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr, including
     * the current state and a history of state changes.
     */
    suspend fun listByoipCidrs(input: ListByoipCidrsRequest): ListByoipCidrsResponse

    /**
     * Lists the IP address ranges that were specified in calls to <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr, including
     * the current state and a history of state changes.
     */
    suspend fun listByoipCidrs(block: ListByoipCidrsRequest.Builder.() -> Unit) = listByoipCidrs(ListByoipCidrsRequest.Builder().apply(block).build())

    /**
     * List the custom routing accelerators for an AWS account.
     */
    suspend fun listCustomRoutingAccelerators(input: ListCustomRoutingAcceleratorsRequest): ListCustomRoutingAcceleratorsResponse

    /**
     * List the custom routing accelerators for an AWS account.
     */
    suspend fun listCustomRoutingAccelerators(block: ListCustomRoutingAcceleratorsRequest.Builder.() -> Unit) = listCustomRoutingAccelerators(ListCustomRoutingAcceleratorsRequest.Builder().apply(block).build())

    /**
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     */
    suspend fun listCustomRoutingEndpointGroups(input: ListCustomRoutingEndpointGroupsRequest): ListCustomRoutingEndpointGroupsResponse

    /**
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     */
    suspend fun listCustomRoutingEndpointGroups(block: ListCustomRoutingEndpointGroupsRequest.Builder.() -> Unit) = listCustomRoutingEndpointGroups(ListCustomRoutingEndpointGroupsRequest.Builder().apply(block).build())

    /**
     * List the listeners for a custom routing accelerator.
     */
    suspend fun listCustomRoutingListeners(input: ListCustomRoutingListenersRequest): ListCustomRoutingListenersResponse

    /**
     * List the listeners for a custom routing accelerator.
     */
    suspend fun listCustomRoutingListeners(block: ListCustomRoutingListenersRequest.Builder.() -> Unit) = listCustomRoutingListeners(ListCustomRoutingListenersRequest.Builder().apply(block).build())

    /**
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance
     * IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator.
     * For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers.
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to
     * your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If you add or remove EC2 instances
     * in your subnet, the port mappings don't change, because the mappings are created when you add the subnet to Global Accelerator.
     * The mappings also include a flag for each destination denoting which destination IP addresses and
     * ports are allowed or denied traffic.
     */
    suspend fun listCustomRoutingPortMappings(input: ListCustomRoutingPortMappingsRequest): ListCustomRoutingPortMappingsResponse

    /**
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance
     * IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator.
     * For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers.
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to
     * your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If you add or remove EC2 instances
     * in your subnet, the port mappings don't change, because the mappings are created when you add the subnet to Global Accelerator.
     * The mappings also include a flag for each destination denoting which destination IP addresses and
     * ports are allowed or denied traffic.
     */
    suspend fun listCustomRoutingPortMappings(block: ListCustomRoutingPortMappingsRequest.Builder.() -> Unit) = listCustomRoutingPortMappings(ListCustomRoutingPortMappingsRequest.Builder().apply(block).build())

    /**
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The
     * response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that
     * span multiple custom routing accelerators in your account, or for scenarios where you only want to
     * list the port mappings for a specific destination instance.
     */
    suspend fun listCustomRoutingPortMappingsByDestination(input: ListCustomRoutingPortMappingsByDestinationRequest): ListCustomRoutingPortMappingsByDestinationResponse

    /**
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The
     * response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that
     * span multiple custom routing accelerators in your account, or for scenarios where you only want to
     * list the port mappings for a specific destination instance.
     */
    suspend fun listCustomRoutingPortMappingsByDestination(block: ListCustomRoutingPortMappingsByDestinationRequest.Builder.() -> Unit) = listCustomRoutingPortMappingsByDestination(ListCustomRoutingPortMappingsByDestinationRequest.Builder().apply(block).build())

    /**
     * List the endpoint groups that are associated with a listener.
     */
    suspend fun listEndpointGroups(input: ListEndpointGroupsRequest): ListEndpointGroupsResponse

    /**
     * List the endpoint groups that are associated with a listener.
     */
    suspend fun listEndpointGroups(block: ListEndpointGroupsRequest.Builder.() -> Unit) = listEndpointGroups(ListEndpointGroupsRequest.Builder().apply(block).build())

    /**
     * List the listeners for an accelerator.
     */
    suspend fun listListeners(input: ListListenersRequest): ListListenersResponse

    /**
     * List the listeners for an accelerator.
     */
    suspend fun listListeners(block: ListListenersRequest.Builder.() -> Unit) = listListeners(ListListenersRequest.Builder().apply(block).build())

    /**
     * List all tags for an accelerator.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List all tags for an accelerator.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Provisions an IP address range to use with your AWS resources through bring your own IP
     * addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned,
     * it is ready to be advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
     * AdvertiseByoipCidr.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    suspend fun provisionByoipCidr(input: ProvisionByoipCidrRequest): ProvisionByoipCidrResponse

    /**
     * Provisions an IP address range to use with your AWS resources through bring your own IP
     * addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned,
     * it is ready to be advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
     * AdvertiseByoipCidr.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    suspend fun provisionByoipCidr(block: ProvisionByoipCidrRequest.Builder.() -> Unit) = provisionByoipCidr(ProvisionByoipCidrRequest.Builder().apply(block).build())

    /**
     * Remove endpoints from a custom routing accelerator.
     */
    suspend fun removeCustomRoutingEndpoints(input: RemoveCustomRoutingEndpointsRequest): RemoveCustomRoutingEndpointsResponse

    /**
     * Remove endpoints from a custom routing accelerator.
     */
    suspend fun removeCustomRoutingEndpoints(block: RemoveCustomRoutingEndpointsRequest.Builder.() -> Unit) = removeCustomRoutingEndpoints(RemoveCustomRoutingEndpointsRequest.Builder().apply(block).build())

    /**
     * Add tags to an accelerator resource.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Add tags to an accelerator resource.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value.
     * The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value.
     * The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Update an accelerator.
     * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
     * US West (Oregon) Region to create or update accelerators.
     */
    suspend fun updateAccelerator(input: UpdateAcceleratorRequest): UpdateAcceleratorResponse

    /**
     * Update an accelerator.
     * Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
     * US West (Oregon) Region to create or update accelerators.
     */
    suspend fun updateAccelerator(block: UpdateAcceleratorRequest.Builder.() -> Unit) = updateAccelerator(UpdateAcceleratorRequest.Builder().apply(block).build())

    /**
     * Update the attributes for an accelerator.
     */
    suspend fun updateAcceleratorAttributes(input: UpdateAcceleratorAttributesRequest): UpdateAcceleratorAttributesResponse

    /**
     * Update the attributes for an accelerator.
     */
    suspend fun updateAcceleratorAttributes(block: UpdateAcceleratorAttributesRequest.Builder.() -> Unit) = updateAcceleratorAttributes(UpdateAcceleratorAttributesRequest.Builder().apply(block).build())

    /**
     * Update a custom routing accelerator.
     */
    suspend fun updateCustomRoutingAccelerator(input: UpdateCustomRoutingAcceleratorRequest): UpdateCustomRoutingAcceleratorResponse

    /**
     * Update a custom routing accelerator.
     */
    suspend fun updateCustomRoutingAccelerator(block: UpdateCustomRoutingAcceleratorRequest.Builder.() -> Unit) = updateCustomRoutingAccelerator(UpdateCustomRoutingAcceleratorRequest.Builder().apply(block).build())

    /**
     * Update the attributes for a custom routing accelerator.
     */
    suspend fun updateCustomRoutingAcceleratorAttributes(input: UpdateCustomRoutingAcceleratorAttributesRequest): UpdateCustomRoutingAcceleratorAttributesResponse

    /**
     * Update the attributes for a custom routing accelerator.
     */
    suspend fun updateCustomRoutingAcceleratorAttributes(block: UpdateCustomRoutingAcceleratorAttributesRequest.Builder.() -> Unit) = updateCustomRoutingAcceleratorAttributes(UpdateCustomRoutingAcceleratorAttributesRequest.Builder().apply(block).build())

    /**
     * Update a listener for a custom routing accelerator.
     */
    suspend fun updateCustomRoutingListener(input: UpdateCustomRoutingListenerRequest): UpdateCustomRoutingListenerResponse

    /**
     * Update a listener for a custom routing accelerator.
     */
    suspend fun updateCustomRoutingListener(block: UpdateCustomRoutingListenerRequest.Builder.() -> Unit) = updateCustomRoutingListener(UpdateCustomRoutingListenerRequest.Builder().apply(block).build())

    /**
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     */
    suspend fun updateEndpointGroup(input: UpdateEndpointGroupRequest): UpdateEndpointGroupResponse

    /**
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     */
    suspend fun updateEndpointGroup(block: UpdateEndpointGroupRequest.Builder.() -> Unit) = updateEndpointGroup(UpdateEndpointGroupRequest.Builder().apply(block).build())

    /**
     * Update a listener.
     */
    suspend fun updateListener(input: UpdateListenerRequest): UpdateListenerResponse

    /**
     * Update a listener.
     */
    suspend fun updateListener(block: UpdateListenerRequest.Builder.() -> Unit) = updateListener(UpdateListenerRequest.Builder().apply(block).build())

    /**
     * Stops advertising an address range that is provisioned as an address pool.
     * You can perform this operation at most once every 10 seconds, even if you specify different address
     * ranges each time.
     * It can take a few minutes before traffic to the specified addresses stops routing to AWS because of
     * propagation delays.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    suspend fun withdrawByoipCidr(input: WithdrawByoipCidrRequest): WithdrawByoipCidrResponse

    /**
     * Stops advertising an address range that is provisioned as an address pool.
     * You can perform this operation at most once every 10 seconds, even if you specify different address
     * ranges each time.
     * It can take a few minutes before traffic to the specified addresses stops routing to AWS because of
     * propagation delays.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    suspend fun withdrawByoipCidr(block: WithdrawByoipCidrRequest.Builder.() -> Unit) = withdrawByoipCidr(WithdrawByoipCidrRequest.Builder().apply(block).build())
}
