// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An accelerator is a complex type that includes one or more listeners that process inbound connections and then direct
 * traffic to one or more endpoint groups, each of which includes endpoints, such as load balancers.
 */
class Accelerator private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the accelerator.
     */
    val acceleratorArn: kotlin.String? = builder.acceleratorArn
    /**
     * The date and time that the accelerator was created.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses.
     * The naming convention for the DNS name is the following: A lowercase letter a,
     * followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
     * a1234567890abcdef.awsglobalaccelerator.com.
     * For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
     * Support for DNS Addressing in Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    val dnsName: kotlin.String? = builder.dnsName
    /**
     * Indicates whether the accelerator is enabled. The value is true or false. The default value is true.
     * If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.
     */
    val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The value for the address type must be IPv4.
     */
    val ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = builder.ipAddressType
    /**
     * The static IP addresses that Global Accelerator associates with the accelerator.
     */
    val ipSets: List<IpSet>? = builder.ipSets
    /**
     * The date and time that the accelerator was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the accelerator. The name must contain only alphanumeric characters or
     * hyphens (-), and must not begin or end with a hyphen.
     */
    val name: kotlin.String? = builder.name
    /**
     * Describes the deployment status of the accelerator.
     */
    val status: aws.sdk.kotlin.services.globalaccelerator.model.AcceleratorStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.Accelerator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Accelerator(")
        append("acceleratorArn=$acceleratorArn,")
        append("createdTime=$createdTime,")
        append("dnsName=$dnsName,")
        append("enabled=$enabled,")
        append("ipAddressType=$ipAddressType,")
        append("ipSets=$ipSets,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorArn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (ipSets?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Accelerator

        if (acceleratorArn != other.acceleratorArn) return false
        if (createdTime != other.createdTime) return false
        if (dnsName != other.dnsName) return false
        if (enabled != other.enabled) return false
        if (ipAddressType != other.ipAddressType) return false
        if (ipSets != other.ipSets) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.Accelerator = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the accelerator.
         */
        var acceleratorArn: kotlin.String? = null
        /**
         * The date and time that the accelerator was created.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses.
         * The naming convention for the DNS name is the following: A lowercase letter a,
         * followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
         * a1234567890abcdef.awsglobalaccelerator.com.
         * For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
         * Support for DNS Addressing in Global Accelerator in the AWS Global Accelerator Developer Guide.
         */
        var dnsName: kotlin.String? = null
        /**
         * Indicates whether the accelerator is enabled. The value is true or false. The default value is true.
         * If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.
         */
        var enabled: kotlin.Boolean? = null
        /**
         * The value for the address type must be IPv4.
         */
        var ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = null
        /**
         * The static IP addresses that Global Accelerator associates with the accelerator.
         */
        var ipSets: List<IpSet>? = null
        /**
         * The date and time that the accelerator was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the accelerator. The name must contain only alphanumeric characters or
         * hyphens (-), and must not begin or end with a hyphen.
         */
        var name: kotlin.String? = null
        /**
         * Describes the deployment status of the accelerator.
         */
        var status: aws.sdk.kotlin.services.globalaccelerator.model.AcceleratorStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.Accelerator) : this() {
            this.acceleratorArn = x.acceleratorArn
            this.createdTime = x.createdTime
            this.dnsName = x.dnsName
            this.enabled = x.enabled
            this.ipAddressType = x.ipAddressType
            this.ipSets = x.ipSets
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.Accelerator = Accelerator(this)
    }
}
