// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * Information about an IP address range that is provisioned for use with your AWS resources through
 * bring your own IP address (BYOIP).
 * The following describes each BYOIP State that your IP address range can be in.
 * PENDING_PROVISIONING —
 * You’ve submitted a request to provision an IP address range but it is not yet provisioned with
 * AWS Global Accelerator.
 * READY — The address range is provisioned
 * with AWS Global Accelerator and can be advertised.
 * PENDING_ADVERTISING — You’ve submitted a
 * request for AWS Global Accelerator to advertise an address range but it is not yet being advertised.
 * ADVERTISING — The address range is
 * being advertised by AWS Global Accelerator.
 * PENDING_WITHDRAWING — You’ve submitted
 * a request to withdraw an address range from being advertised but it is still being advertised
 * by AWS Global Accelerator.
 * PENDING_DEPROVISIONING — You’ve submitted a
 * request to deprovision an address range from AWS Global Accelerator but it is still provisioned.
 * DEPROVISIONED — The address range is deprovisioned
 * from AWS Global Accelerator.
 * FAILED_PROVISION  — The request to
 * provision the address range from AWS Global Accelerator was not successful. Please make sure that
 * you provide all of the correct information, and try again. If the request fails
 * a second time, contact AWS support.
 * FAILED_ADVERTISING — The request for AWS Global Accelerator
 * to advertise the address range was not successful. Please make sure that
 * you provide all of the correct information, and try again. If the request fails
 * a second time, contact AWS support.
 * FAILED_WITHDRAW — The request to withdraw
 * the address range from advertising by AWS Global Accelerator was not successful. Please make sure that
 * you provide all of the correct information, and try again. If the request fails
 * a second time, contact AWS support.
 * FAILED_DEPROVISION  — The request to
 * deprovision the address range from AWS Global Accelerator was not successful. Please make sure that
 * you provide all of the correct information, and try again. If the request fails
 * a second time, contact AWS support.
 */
class ByoipCidr private constructor(builder: Builder) {
    /**
     * The address range, in CIDR notation.
     */
    val cidr: kotlin.String? = builder.cidr
    /**
     * A history of status changes for an IP address range that you bring to AWS Global Accelerator
     * through bring your own IP address (BYOIP).
     */
    val events: List<ByoipCidrEvent>? = builder.events
    /**
     * The state of the address pool.
     */
    val state: aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidrState? = builder.state

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidr = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ByoipCidr(")
        append("cidr=$cidr,")
        append("events=$events,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidr?.hashCode() ?: 0
        result = 31 * result + (events?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ByoipCidr

        if (cidr != other.cidr) return false
        if (events != other.events) return false
        if (state != other.state) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidr = Builder(this).apply(block).build()

    class Builder {
        /**
         * The address range, in CIDR notation.
         */
        var cidr: kotlin.String? = null
        /**
         * A history of status changes for an IP address range that you bring to AWS Global Accelerator
         * through bring your own IP address (BYOIP).
         */
        var events: List<ByoipCidrEvent>? = null
        /**
         * The state of the address pool.
         */
        var state: aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidrState? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidr) : this() {
            this.cidr = x.cidr
            this.events = x.events
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidr = ByoipCidr(this)
    }
}
