// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



class CreateAcceleratorRequest private constructor(builder: Builder) {
    /**
     * Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
     * If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.
     */
    val enabled: kotlin.Boolean? = builder.enabled
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
     * uniqueness—of an accelerator.
     */
    val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The value for the address type must be IPv4.
     */
    val ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = builder.ipAddressType
    /**
     * Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
     * from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
     * specify one or two addresses, separated by a space. Do not include the /32 suffix.
     * Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
     * one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
     * accelerator from the AWS IP address pool.
     * Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
     * accelerator with the new addresses.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
     * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
     */
    val ipAddresses: List<String>? = builder.ipAddresses
    /**
     * The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
     * hyphens (-), and must not begin or end with a hyphen.
     */
    val name: kotlin.String? = builder.name
    /**
     * Create tags for an accelerator.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
     * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAcceleratorRequest(")
        append("enabled=$enabled,")
        append("idempotencyToken=$idempotencyToken,")
        append("ipAddressType=$ipAddressType,")
        append("ipAddresses=$ipAddresses,")
        append("name=$name,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (ipAddresses?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAcceleratorRequest

        if (enabled != other.enabled) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (ipAddressType != other.ipAddressType) return false
        if (ipAddresses != other.ipAddresses) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
         * If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.
         */
        var enabled: kotlin.Boolean? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
         * uniqueness—of an accelerator.
         */
        var idempotencyToken: kotlin.String? = null
        /**
         * The value for the address type must be IPv4.
         */
        var ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = null
        /**
         * Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
         * from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
         * specify one or two addresses, separated by a space. Do not include the /32 suffix.
         * Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
         * one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
         * accelerator from the AWS IP address pool.
         * Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
         * accelerator with the new addresses.
         * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
         * IP Addresses (BYOIP) in the AWS Global Accelerator Developer Guide.
         */
        var ipAddresses: List<String>? = null
        /**
         * The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
         * hyphens (-), and must not begin or end with a hyphen.
         */
        var name: kotlin.String? = null
        /**
         * Create tags for an accelerator.
         * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
         * in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest) : this() {
            this.enabled = x.enabled
            this.idempotencyToken = x.idempotencyToken
            this.ipAddressType = x.ipAddressType
            this.ipAddresses = x.ipAddresses
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest = CreateAcceleratorRequest(this)
    }
}
