// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * A complex type for a listener.
 */
class Listener private constructor(builder: Builder) {
    /**
     * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
     * regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
     * route each client to the same specific endpoint.
     * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
     * affinity is NONE, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
     * destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
     * endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
     * be always routed to the same endpoint because the hash value changes.
     * If you want a given client to always be routed to the same endpoint, set client affinity to SOURCE_IP
     * instead. When you use the SOURCE_IP setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
     * source (client) IP address and destination IP address—to select the hash value.
     * The default value is NONE.
     */
    val clientAffinity: aws.sdk.kotlin.services.globalaccelerator.model.ClientAffinity? = builder.clientAffinity
    /**
     * The Amazon Resource Name (ARN) of the listener.
     */
    val listenerArn: kotlin.String? = builder.listenerArn
    /**
     * The list of port ranges for the connections from clients to the accelerator.
     */
    val portRanges: List<PortRange>? = builder.portRanges
    /**
     * The protocol for the connections from clients to the accelerator.
     */
    val protocol: aws.sdk.kotlin.services.globalaccelerator.model.Protocol? = builder.protocol

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.Listener = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Listener(")
        append("clientAffinity=$clientAffinity,")
        append("listenerArn=$listenerArn,")
        append("portRanges=$portRanges,")
        append("protocol=$protocol)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientAffinity?.hashCode() ?: 0
        result = 31 * result + (listenerArn?.hashCode() ?: 0)
        result = 31 * result + (portRanges?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Listener

        if (clientAffinity != other.clientAffinity) return false
        if (listenerArn != other.listenerArn) return false
        if (portRanges != other.portRanges) return false
        if (protocol != other.protocol) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.Listener = Builder(this).apply(block).build()

    class Builder {
        /**
         * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
         * regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
         * route each client to the same specific endpoint.
         * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
         * affinity is NONE, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
         * destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
         * endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
         * be always routed to the same endpoint because the hash value changes.
         * If you want a given client to always be routed to the same endpoint, set client affinity to SOURCE_IP
         * instead. When you use the SOURCE_IP setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
         * source (client) IP address and destination IP address—to select the hash value.
         * The default value is NONE.
         */
        var clientAffinity: aws.sdk.kotlin.services.globalaccelerator.model.ClientAffinity? = null
        /**
         * The Amazon Resource Name (ARN) of the listener.
         */
        var listenerArn: kotlin.String? = null
        /**
         * The list of port ranges for the connections from clients to the accelerator.
         */
        var portRanges: List<PortRange>? = null
        /**
         * The protocol for the connections from clients to the accelerator.
         */
        var protocol: aws.sdk.kotlin.services.globalaccelerator.model.Protocol? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.Listener) : this() {
            this.clientAffinity = x.clientAffinity
            this.listenerArn = x.listenerArn
            this.portRanges = x.portRanges
            this.protocol = x.protocol
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.Listener = Listener(this)
    }
}
