// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * Override specific listener ports used to route traffic to endpoints that are part of an endpoint group.
 * For example, you can create a port override in which the listener
 * receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
 * and 1443, respectively, on the endpoints.
 * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
 * Port overrides in the AWS Global Accelerator Developer Guide.
 */
class PortOverride private constructor(builder: Builder) {
    /**
     * The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint,
     * such as the Application Load Balancer or Amazon EC2 instance.
     */
    val endpointPort: kotlin.Int? = builder.endpointPort
    /**
     * The listener port that you want to map to a specific endpoint port. This is the port that user traffic
     * arrives to the Global Accelerator on.
     */
    val listenerPort: kotlin.Int? = builder.listenerPort

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.PortOverride = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PortOverride(")
        append("endpointPort=$endpointPort,")
        append("listenerPort=$listenerPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointPort ?: 0
        result = 31 * result + (listenerPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PortOverride

        if (endpointPort != other.endpointPort) return false
        if (listenerPort != other.listenerPort) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.PortOverride = Builder(this).apply(block).build()

    class Builder {
        /**
         * The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint,
         * such as the Application Load Balancer or Amazon EC2 instance.
         */
        var endpointPort: kotlin.Int? = null
        /**
         * The listener port that you want to map to a specific endpoint port. This is the port that user traffic
         * arrives to the Global Accelerator on.
         */
        var listenerPort: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.PortOverride) : this() {
            this.endpointPort = x.endpointPort
            this.listenerPort = x.listenerPort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.PortOverride = PortOverride(this)
    }
}
