// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.grafana.model.*
import aws.sdk.kotlin.services.grafana.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "grafana"
public const val ServiceApiVersion: String = "2020-08-18"
public const val SdkVersion: String = "0.17.10-beta"

internal class DefaultGrafanaClient(override val config: GrafanaClient.Config) : GrafanaClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For more information, see [Upgrade a workspace to Grafana Enterprise](https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html).
     */
    override suspend fun associateLicense(input: AssociateLicenseRequest): AssociateLicenseResponse {
        val op = SdkHttpOperation.build<AssociateLicenseRequest, AssociateLicenseResponse> {
            serializer = AssociateLicenseOperationSerializer()
            deserializer = AssociateLicenseOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "AssociateLicense"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a *workspace*. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
     *
     * Don't use `CreateWorkspace` to modify an existing workspace. Instead, use [UpdateWorkspace](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html).
     */
    override suspend fun createWorkspace(input: CreateWorkspaceRequest): CreateWorkspaceResponse {
        val op = SdkHttpOperation.build<CreateWorkspaceRequest, CreateWorkspaceResponse> {
            serializer = CreateWorkspaceOperationSerializer()
            deserializer = CreateWorkspaceOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateWorkspace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an API key for the workspace. This key can be used to authenticate requests sent to the workspace's HTTP API. See [ https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html]( https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html) for available APIs and example requests.
     */
    override suspend fun createWorkspaceApiKey(input: CreateWorkspaceApiKeyRequest): CreateWorkspaceApiKeyResponse {
        val op = SdkHttpOperation.build<CreateWorkspaceApiKeyRequest, CreateWorkspaceApiKeyResponse> {
            serializer = CreateWorkspaceApiKeyOperationSerializer()
            deserializer = CreateWorkspaceApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkspaceApiKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Managed Grafana workspace.
     */
    override suspend fun deleteWorkspace(input: DeleteWorkspaceRequest): DeleteWorkspaceResponse {
        val op = SdkHttpOperation.build<DeleteWorkspaceRequest, DeleteWorkspaceResponse> {
            serializer = DeleteWorkspaceOperationSerializer()
            deserializer = DeleteWorkspaceOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteWorkspace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an API key for a workspace.
     */
    override suspend fun deleteWorkspaceApiKey(input: DeleteWorkspaceApiKeyRequest): DeleteWorkspaceApiKeyResponse {
        val op = SdkHttpOperation.build<DeleteWorkspaceApiKeyRequest, DeleteWorkspaceApiKeyResponse> {
            serializer = DeleteWorkspaceApiKeyOperationSerializer()
            deserializer = DeleteWorkspaceApiKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkspaceApiKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays information about one Amazon Managed Grafana workspace.
     */
    override suspend fun describeWorkspace(input: DescribeWorkspaceRequest): DescribeWorkspaceResponse {
        val op = SdkHttpOperation.build<DescribeWorkspaceRequest, DescribeWorkspaceResponse> {
            serializer = DescribeWorkspaceOperationSerializer()
            deserializer = DescribeWorkspaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorkspace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
     */
    override suspend fun describeWorkspaceAuthentication(input: DescribeWorkspaceAuthenticationRequest): DescribeWorkspaceAuthenticationResponse {
        val op = SdkHttpOperation.build<DescribeWorkspaceAuthenticationRequest, DescribeWorkspaceAuthenticationResponse> {
            serializer = DescribeWorkspaceAuthenticationOperationSerializer()
            deserializer = DescribeWorkspaceAuthenticationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorkspaceAuthentication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the Grafana Enterprise license from a workspace.
     */
    override suspend fun disassociateLicense(input: DisassociateLicenseRequest): DisassociateLicenseResponse {
        val op = SdkHttpOperation.build<DisassociateLicenseRequest, DisassociateLicenseResponse> {
            serializer = DisassociateLicenseOperationSerializer()
            deserializer = DisassociateLicenseOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DisassociateLicense"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the users and groups who have the Grafana `Admin` and `Editor` roles in this workspace. If you use this operation without specifying `userId` or `groupId`, the operation returns the roles of all users and groups. If you specify a `userId` or a `groupId`, only the roles for that user or group are returned. If you do this, you can specify only one `userId` or one `groupId`.
     */
    override suspend fun listPermissions(input: ListPermissionsRequest): ListPermissionsResponse {
        val op = SdkHttpOperation.build<ListPermissionsRequest, ListPermissionsResponse> {
            serializer = ListPermissionsOperationSerializer()
            deserializer = ListPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The `ListTagsForResource` operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the `resourceArn`. Currently, the only resource that can be tagged is a workspace.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace. For more complete information about one workspace, use [DescribeWorkspace](https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html).
     */
    override suspend fun listWorkspaces(input: ListWorkspacesRequest): ListWorkspacesResponse {
        val op = SdkHttpOperation.build<ListWorkspacesRequest, ListWorkspacesResponse> {
            serializer = ListWorkspacesOperationSerializer()
            deserializer = ListWorkspacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkspaces"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The `TagResource` operation associates tags with an Amazon Managed Grafana resource. Currently, the only resource that can be tagged is workspaces.
     *
     * If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The `UntagResource` operation removes the association of the tag with the Amazon Managed Grafana resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates which users in a workspace have the Grafana `Admin` or `Editor` roles.
     */
    override suspend fun updatePermissions(input: UpdatePermissionsRequest): UpdatePermissionsResponse {
        val op = SdkHttpOperation.build<UpdatePermissionsRequest, UpdatePermissionsResponse> {
            serializer = UpdatePermissionsOperationSerializer()
            deserializer = UpdatePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.
     *
     * To modify the user authentication methods that the workspace uses, such as SAML or Amazon Web Services SSO, use [UpdateWorkspaceAuthentication](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html).
     *
     * To modify which users in the workspace have the `Admin` and `Editor` Grafana roles, use [UpdatePermissions](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html).
     */
    override suspend fun updateWorkspace(input: UpdateWorkspaceRequest): UpdateWorkspaceResponse {
        val op = SdkHttpOperation.build<UpdateWorkspaceRequest, UpdateWorkspaceResponse> {
            serializer = UpdateWorkspaceOperationSerializer()
            deserializer = UpdateWorkspaceOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateWorkspace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
     */
    override suspend fun updateWorkspaceAuthentication(input: UpdateWorkspaceAuthenticationRequest): UpdateWorkspaceAuthenticationResponse {
        val op = SdkHttpOperation.build<UpdateWorkspaceAuthenticationRequest, UpdateWorkspaceAuthenticationResponse> {
            serializer = UpdateWorkspaceAuthenticationOperationSerializer()
            deserializer = UpdateWorkspaceAuthenticationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkspaceAuthentication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "grafana"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "grafana")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
