// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains some information about one workspace in the account.
 */
public class WorkspaceSummary private constructor(builder: Builder) {
    /**
     * A structure containing information about the authentication methods used in the workspace.
     */
    public val authentication: aws.sdk.kotlin.services.grafana.model.AuthenticationSummary? = builder.authentication
    /**
     * The date that the workspace was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The customer-entered description of the workspace.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The URL endpoint to use to access the Grafana console in the workspace.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The Grafana version that the workspace is running.
     */
    public val grafanaVersion: kotlin.String? = builder.grafanaVersion
    /**
     * The unique ID of the workspace.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The most recent date that the workspace was modified.
     */
    public val modified: aws.smithy.kotlin.runtime.time.Instant? = builder.modified
    /**
     * The name of the workspace.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, which allows Amazon Managed Grafana to use these channels.
     */
    public val notificationDestinations: List<NotificationDestinationType>? = builder.notificationDestinations
    /**
     * The current status of the workspace.
     */
    public val status: aws.sdk.kotlin.services.grafana.model.WorkspaceStatus? = builder.status
    /**
     * The list of tags associated with the workspace.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.WorkspaceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceSummary(")
        append("authentication=$authentication,")
        append("created=$created,")
        append("description=*** Sensitive Data Redacted ***,")
        append("endpoint=$endpoint,")
        append("grafanaVersion=$grafanaVersion,")
        append("id=$id,")
        append("modified=$modified,")
        append("name=*** Sensitive Data Redacted ***,")
        append("notificationDestinations=$notificationDestinations,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authentication?.hashCode() ?: 0
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (grafanaVersion?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (modified?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notificationDestinations?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceSummary

        if (authentication != other.authentication) return false
        if (created != other.created) return false
        if (description != other.description) return false
        if (endpoint != other.endpoint) return false
        if (grafanaVersion != other.grafanaVersion) return false
        if (id != other.id) return false
        if (modified != other.modified) return false
        if (name != other.name) return false
        if (notificationDestinations != other.notificationDestinations) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.WorkspaceSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A structure containing information about the authentication methods used in the workspace.
         */
        public var authentication: aws.sdk.kotlin.services.grafana.model.AuthenticationSummary? = null
        /**
         * The date that the workspace was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The customer-entered description of the workspace.
         */
        public var description: kotlin.String? = null
        /**
         * The URL endpoint to use to access the Grafana console in the workspace.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The Grafana version that the workspace is running.
         */
        public var grafanaVersion: kotlin.String? = null
        /**
         * The unique ID of the workspace.
         */
        public var id: kotlin.String? = null
        /**
         * The most recent date that the workspace was modified.
         */
        public var modified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the workspace.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, which allows Amazon Managed Grafana to use these channels.
         */
        public var notificationDestinations: List<NotificationDestinationType>? = null
        /**
         * The current status of the workspace.
         */
        public var status: aws.sdk.kotlin.services.grafana.model.WorkspaceStatus? = null
        /**
         * The list of tags associated with the workspace.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.WorkspaceSummary) : this() {
            this.authentication = x.authentication
            this.created = x.created
            this.description = x.description
            this.endpoint = x.endpoint
            this.grafanaVersion = x.grafanaVersion
            this.id = x.id
            this.modified = x.modified
            this.name = x.name
            this.notificationDestinations = x.notificationDestinations
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.WorkspaceSummary = WorkspaceSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.AuthenticationSummary] inside the given [block]
         */
        public fun authentication(block: aws.sdk.kotlin.services.grafana.model.AuthenticationSummary.Builder.() -> kotlin.Unit) {
            this.authentication = aws.sdk.kotlin.services.grafana.model.AuthenticationSummary.invoke(block)
        }
    }
}
