// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.grafana.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.grafana.endpoints.EndpointProvider
import aws.sdk.kotlin.services.grafana.model.*
import aws.sdk.kotlin.services.grafana.model.AssociateLicenseRequest
import aws.sdk.kotlin.services.grafana.model.AssociateLicenseResponse
import aws.sdk.kotlin.services.grafana.model.CreateWorkspaceApiKeyRequest
import aws.sdk.kotlin.services.grafana.model.CreateWorkspaceApiKeyResponse
import aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest
import aws.sdk.kotlin.services.grafana.model.CreateWorkspaceResponse
import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceApiKeyRequest
import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceApiKeyResponse
import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceRequest
import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceResponse
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceAuthenticationRequest
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceAuthenticationResponse
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceRequest
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceResponse
import aws.sdk.kotlin.services.grafana.model.DisassociateLicenseRequest
import aws.sdk.kotlin.services.grafana.model.DisassociateLicenseResponse
import aws.sdk.kotlin.services.grafana.model.ListPermissionsRequest
import aws.sdk.kotlin.services.grafana.model.ListPermissionsResponse
import aws.sdk.kotlin.services.grafana.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.grafana.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.grafana.model.ListWorkspacesRequest
import aws.sdk.kotlin.services.grafana.model.ListWorkspacesResponse
import aws.sdk.kotlin.services.grafana.model.TagResourceRequest
import aws.sdk.kotlin.services.grafana.model.TagResourceResponse
import aws.sdk.kotlin.services.grafana.model.UntagResourceRequest
import aws.sdk.kotlin.services.grafana.model.UntagResourceResponse
import aws.sdk.kotlin.services.grafana.model.UpdatePermissionsRequest
import aws.sdk.kotlin.services.grafana.model.UpdatePermissionsResponse
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceAuthenticationRequest
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceAuthenticationResponse
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * Amazon Managed Grafana is a fully managed and secure data visualization service that you can use to instantly query, correlate, and visualize operational metrics, logs, and traces from multiple sources. Amazon Managed Grafana makes it easy to deploy, operate, and scale Grafana, a widely deployed data visualization tool that is popular for its extensible data support.
 *
 * With Amazon Managed Grafana, you create logically isolated Grafana servers called *workspaces*. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces without having to build, package, or deploy any hardware to run Grafana servers.
 */
public interface GrafanaClient : SdkClient {

    override val serviceName: String
        get() = "grafana"
    /**
     * GrafanaClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): GrafanaClient {
            val config = Config.Builder().apply(block).build()
            return DefaultGrafanaClient(config)
        }

        public operator fun invoke(config: Config): GrafanaClient = DefaultGrafanaClient(config)

        /**
         * Construct a [GrafanaClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): GrafanaClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultGrafanaClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "grafana")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For more information, see [Upgrade a workspace to Grafana Enterprise](https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html).
     */
    public suspend fun associateLicense(input: AssociateLicenseRequest): AssociateLicenseResponse

    /**
     * Creates a *workspace*. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
     *
     * Don't use `CreateWorkspace` to modify an existing workspace. Instead, use [UpdateWorkspace](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html).
     */
    public suspend fun createWorkspace(input: CreateWorkspaceRequest): CreateWorkspaceResponse

    /**
     * Creates an API key for the workspace. This key can be used to authenticate requests sent to the workspace's HTTP API. See [ https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html]( https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html) for available APIs and example requests.
     */
    public suspend fun createWorkspaceApiKey(input: CreateWorkspaceApiKeyRequest): CreateWorkspaceApiKeyResponse

    /**
     * Deletes an Amazon Managed Grafana workspace.
     */
    public suspend fun deleteWorkspace(input: DeleteWorkspaceRequest): DeleteWorkspaceResponse

    /**
     * Deletes an API key for a workspace.
     */
    public suspend fun deleteWorkspaceApiKey(input: DeleteWorkspaceApiKeyRequest): DeleteWorkspaceApiKeyResponse

    /**
     * Displays information about one Amazon Managed Grafana workspace.
     */
    public suspend fun describeWorkspace(input: DescribeWorkspaceRequest): DescribeWorkspaceResponse

    /**
     * Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
     */
    public suspend fun describeWorkspaceAuthentication(input: DescribeWorkspaceAuthenticationRequest): DescribeWorkspaceAuthenticationResponse

    /**
     * Removes the Grafana Enterprise license from a workspace.
     */
    public suspend fun disassociateLicense(input: DisassociateLicenseRequest): DisassociateLicenseResponse

    /**
     * Lists the users and groups who have the Grafana `Admin` and `Editor` roles in this workspace. If you use this operation without specifying `userId` or `groupId`, the operation returns the roles of all users and groups. If you specify a `userId` or a `groupId`, only the roles for that user or group are returned. If you do this, you can specify only one `userId` or one `groupId`.
     */
    public suspend fun listPermissions(input: ListPermissionsRequest): ListPermissionsResponse

    /**
     * The `ListTagsForResource` operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the `resourceArn`. Currently, the only resource that can be tagged is a workspace.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace. For more complete information about one workspace, use [DescribeWorkspace](https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html).
     */
    public suspend fun listWorkspaces(input: ListWorkspacesRequest = ListWorkspacesRequest {}): ListWorkspacesResponse

    /**
     * The `TagResource` operation associates tags with an Amazon Managed Grafana resource. Currently, the only resource that can be tagged is workspaces.
     *
     * If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * The `UntagResource` operation removes the association of the tag with the Amazon Managed Grafana resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates which users in a workspace have the Grafana `Admin` or `Editor` roles.
     */
    public suspend fun updatePermissions(input: UpdatePermissionsRequest): UpdatePermissionsResponse

    /**
     * Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.
     *
     * To modify the user authentication methods that the workspace uses, such as SAML or Amazon Web Services SSO, use [UpdateWorkspaceAuthentication](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html).
     *
     * To modify which users in the workspace have the `Admin` and `Editor` Grafana roles, use [UpdatePermissions](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html).
     */
    public suspend fun updateWorkspace(input: UpdateWorkspaceRequest): UpdateWorkspaceResponse

    /**
     * Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
     */
    public suspend fun updateWorkspaceAuthentication(input: UpdateWorkspaceAuthenticationRequest): UpdateWorkspaceAuthenticationResponse
}

/**
 * Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For more information, see [Upgrade a workspace to Grafana Enterprise](https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html).
 */
public suspend inline fun GrafanaClient.associateLicense(crossinline block: AssociateLicenseRequest.Builder.() -> Unit): AssociateLicenseResponse = associateLicense(AssociateLicenseRequest.Builder().apply(block).build())

/**
 * Creates a *workspace*. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
 *
 * Don't use `CreateWorkspace` to modify an existing workspace. Instead, use [UpdateWorkspace](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html).
 */
public suspend inline fun GrafanaClient.createWorkspace(crossinline block: CreateWorkspaceRequest.Builder.() -> Unit): CreateWorkspaceResponse = createWorkspace(CreateWorkspaceRequest.Builder().apply(block).build())

/**
 * Creates an API key for the workspace. This key can be used to authenticate requests sent to the workspace's HTTP API. See [ https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html]( https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html) for available APIs and example requests.
 */
public suspend inline fun GrafanaClient.createWorkspaceApiKey(crossinline block: CreateWorkspaceApiKeyRequest.Builder.() -> Unit): CreateWorkspaceApiKeyResponse = createWorkspaceApiKey(CreateWorkspaceApiKeyRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Managed Grafana workspace.
 */
public suspend inline fun GrafanaClient.deleteWorkspace(crossinline block: DeleteWorkspaceRequest.Builder.() -> Unit): DeleteWorkspaceResponse = deleteWorkspace(DeleteWorkspaceRequest.Builder().apply(block).build())

/**
 * Deletes an API key for a workspace.
 */
public suspend inline fun GrafanaClient.deleteWorkspaceApiKey(crossinline block: DeleteWorkspaceApiKeyRequest.Builder.() -> Unit): DeleteWorkspaceApiKeyResponse = deleteWorkspaceApiKey(DeleteWorkspaceApiKeyRequest.Builder().apply(block).build())

/**
 * Displays information about one Amazon Managed Grafana workspace.
 */
public suspend inline fun GrafanaClient.describeWorkspace(crossinline block: DescribeWorkspaceRequest.Builder.() -> Unit): DescribeWorkspaceResponse = describeWorkspace(DescribeWorkspaceRequest.Builder().apply(block).build())

/**
 * Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
 */
public suspend inline fun GrafanaClient.describeWorkspaceAuthentication(crossinline block: DescribeWorkspaceAuthenticationRequest.Builder.() -> Unit): DescribeWorkspaceAuthenticationResponse = describeWorkspaceAuthentication(DescribeWorkspaceAuthenticationRequest.Builder().apply(block).build())

/**
 * Removes the Grafana Enterprise license from a workspace.
 */
public suspend inline fun GrafanaClient.disassociateLicense(crossinline block: DisassociateLicenseRequest.Builder.() -> Unit): DisassociateLicenseResponse = disassociateLicense(DisassociateLicenseRequest.Builder().apply(block).build())

/**
 * Lists the users and groups who have the Grafana `Admin` and `Editor` roles in this workspace. If you use this operation without specifying `userId` or `groupId`, the operation returns the roles of all users and groups. If you specify a `userId` or a `groupId`, only the roles for that user or group are returned. If you do this, you can specify only one `userId` or one `groupId`.
 */
public suspend inline fun GrafanaClient.listPermissions(crossinline block: ListPermissionsRequest.Builder.() -> Unit): ListPermissionsResponse = listPermissions(ListPermissionsRequest.Builder().apply(block).build())

/**
 * The `ListTagsForResource` operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the `resourceArn`. Currently, the only resource that can be tagged is a workspace.
 */
public suspend inline fun GrafanaClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace. For more complete information about one workspace, use [DescribeWorkspace](https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html).
 */
public suspend inline fun GrafanaClient.listWorkspaces(crossinline block: ListWorkspacesRequest.Builder.() -> Unit): ListWorkspacesResponse = listWorkspaces(ListWorkspacesRequest.Builder().apply(block).build())

/**
 * The `TagResource` operation associates tags with an Amazon Managed Grafana resource. Currently, the only resource that can be tagged is workspaces.
 *
 * If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 */
public suspend inline fun GrafanaClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * The `UntagResource` operation removes the association of the tag with the Amazon Managed Grafana resource.
 */
public suspend inline fun GrafanaClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates which users in a workspace have the Grafana `Admin` or `Editor` roles.
 */
public suspend inline fun GrafanaClient.updatePermissions(crossinline block: UpdatePermissionsRequest.Builder.() -> Unit): UpdatePermissionsResponse = updatePermissions(UpdatePermissionsRequest.Builder().apply(block).build())

/**
 * Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.
 *
 * To modify the user authentication methods that the workspace uses, such as SAML or Amazon Web Services SSO, use [UpdateWorkspaceAuthentication](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html).
 *
 * To modify which users in the workspace have the `Admin` and `Editor` Grafana roles, use [UpdatePermissions](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html).
 */
public suspend inline fun GrafanaClient.updateWorkspace(crossinline block: UpdateWorkspaceRequest.Builder.() -> Unit): UpdateWorkspaceResponse = updateWorkspace(UpdateWorkspaceRequest.Builder().apply(block).build())

/**
 * Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
 */
public suspend inline fun GrafanaClient.updateWorkspaceAuthentication(crossinline block: UpdateWorkspaceAuthenticationRequest.Builder.() -> Unit): UpdateWorkspaceAuthenticationResponse = updateWorkspaceAuthentication(UpdateWorkspaceAuthenticationRequest.Builder().apply(block).build())
